/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.jackson.databind.ser.std;

import io.ap4k.deps.jackson.core.JsonGenerator;
import io.ap4k.deps.jackson.databind.SerializerProvider;
import io.ap4k.deps.jackson.databind.ser.std.StdScalarSerializer;
import io.ap4k.deps.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            gen.writeBinary(bbuf.array(), 0, bbuf.limit());
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }
}

