/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.jackson.databind.ser.std;

import io.ap4k.deps.jackson.core.JsonGenerator;
import io.ap4k.deps.jackson.databind.JavaType;
import io.ap4k.deps.jackson.databind.JsonMappingException;
import io.ap4k.deps.jackson.databind.JsonNode;
import io.ap4k.deps.jackson.databind.SerializerProvider;
import io.ap4k.deps.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.ap4k.deps.jackson.databind.jsontype.TypeSerializer;
import io.ap4k.deps.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class RawSerializer<T>
extends StdSerializer<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForScalar(value, jgen);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar(value, jgen);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

