/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.Cluster;
import io.ap4k.deps.kubernetes.api.model.ClusterFluent;
import io.ap4k.deps.kubernetes.api.model.ClusterFluentImpl;

public class ClusterBuilder
extends ClusterFluentImpl<ClusterBuilder>
implements VisitableBuilder<Cluster, ClusterBuilder> {
    ClusterFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ClusterBuilder() {
        this(true);
    }

    public ClusterBuilder(Boolean validationEnabled) {
        this(new Cluster(), validationEnabled);
    }

    public ClusterBuilder(ClusterFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ClusterBuilder(ClusterFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Cluster(), validationEnabled);
    }

    public ClusterBuilder(ClusterFluent<?> fluent, Cluster instance) {
        this(fluent, instance, true);
    }

    public ClusterBuilder(ClusterFluent<?> fluent, Cluster instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCertificateAuthority(instance.getCertificateAuthority());
        fluent.withCertificateAuthorityData(instance.getCertificateAuthorityData());
        fluent.withExtensions(instance.getExtensions());
        fluent.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
        fluent.withServer(instance.getServer());
        this.validationEnabled = validationEnabled;
    }

    public ClusterBuilder(Cluster instance) {
        this(instance, (Boolean)true);
    }

    public ClusterBuilder(Cluster instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCertificateAuthority(instance.getCertificateAuthority());
        this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
        this.withExtensions(instance.getExtensions());
        this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
        this.withServer(instance.getServer());
        this.validationEnabled = validationEnabled;
    }

    public ClusterBuilder(Validator validator) {
        this(new Cluster(), (Boolean)true);
    }

    public ClusterBuilder(ClusterFluent<?> fluent, Cluster instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCertificateAuthority(instance.getCertificateAuthority());
        fluent.withCertificateAuthorityData(instance.getCertificateAuthorityData());
        fluent.withExtensions(instance.getExtensions());
        fluent.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
        fluent.withServer(instance.getServer());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ClusterBuilder(Cluster instance, Validator validator) {
        this.fluent = this;
        this.withCertificateAuthority(instance.getCertificateAuthority());
        this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
        this.withExtensions(instance.getExtensions());
        this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
        this.withServer(instance.getServer());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Cluster build() {
        Cluster buildable = new Cluster(this.fluent.getCertificateAuthority(), this.fluent.getCertificateAuthorityData(), this.fluent.getExtensions(), this.fluent.isInsecureSkipTlsVerify(), this.fluent.getServer());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterBuilder that = (ClusterBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

