/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.ContainerPort;
import io.ap4k.deps.kubernetes.api.model.ContainerPortFluent;
import io.ap4k.deps.kubernetes.api.model.ContainerPortFluentImpl;

public class ContainerPortBuilder
extends ContainerPortFluentImpl<ContainerPortBuilder>
implements VisitableBuilder<ContainerPort, ContainerPortBuilder> {
    ContainerPortFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ContainerPortBuilder() {
        this(true);
    }

    public ContainerPortBuilder(Boolean validationEnabled) {
        this(new ContainerPort(), validationEnabled);
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerPort(), validationEnabled);
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent, ContainerPort instance) {
        this(fluent, instance, true);
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent, ContainerPort instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withContainerPort(instance.getContainerPort());
        fluent.withHostIP(instance.getHostIP());
        fluent.withHostPort(instance.getHostPort());
        fluent.withName(instance.getName());
        fluent.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    public ContainerPortBuilder(ContainerPort instance) {
        this(instance, (Boolean)true);
    }

    public ContainerPortBuilder(ContainerPort instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withContainerPort(instance.getContainerPort());
        this.withHostIP(instance.getHostIP());
        this.withHostPort(instance.getHostPort());
        this.withName(instance.getName());
        this.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    public ContainerPortBuilder(Validator validator) {
        this(new ContainerPort(), (Boolean)true);
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent, ContainerPort instance, Validator validator) {
        this.fluent = fluent;
        fluent.withContainerPort(instance.getContainerPort());
        fluent.withHostIP(instance.getHostIP());
        fluent.withHostPort(instance.getHostPort());
        fluent.withName(instance.getName());
        fluent.withProtocol(instance.getProtocol());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ContainerPortBuilder(ContainerPort instance, Validator validator) {
        this.fluent = this;
        this.withContainerPort(instance.getContainerPort());
        this.withHostIP(instance.getHostIP());
        this.withHostPort(instance.getHostPort());
        this.withName(instance.getName());
        this.withProtocol(instance.getProtocol());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ContainerPort build() {
        ContainerPort buildable = new ContainerPort(this.fluent.getContainerPort(), this.fluent.getHostIP(), this.fluent.getHostPort(), this.fluent.getName(), this.fluent.getProtocol());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerPortBuilder that = (ContainerPortBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

