/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.model.LabelSelector;
import io.ap4k.deps.kubernetes.api.model.LabelSelectorFluent;
import io.ap4k.deps.kubernetes.api.model.LabelSelectorRequirement;
import io.ap4k.deps.kubernetes.api.model.LabelSelectorRequirementBuilder;
import io.ap4k.deps.kubernetes.api.model.LabelSelectorRequirementFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LabelSelectorFluentImpl<A extends LabelSelectorFluent<A>>
extends BaseFluent<A>
implements LabelSelectorFluent<A> {
    private List<LabelSelectorRequirementBuilder> matchExpressions;
    private Map<String, String> matchLabels;

    public LabelSelectorFluentImpl() {
    }

    public LabelSelectorFluentImpl(LabelSelector instance) {
        this.withMatchExpressions(instance.getMatchExpressions());
        this.withMatchLabels(instance.getMatchLabels());
    }

    @Override
    public A addToMatchExpressions(int index, LabelSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirementBuilder>();
        }
        LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.matchExpressions.add(index >= 0 ? index : this.matchExpressions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMatchExpressions(int index, LabelSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirementBuilder>();
        }
        LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.matchExpressions.size()) {
            this.matchExpressions.add(builder);
        } else {
            this.matchExpressions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMatchExpressions(LabelSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirementBuilder>();
        }
        for (LabelSelectorRequirement item : items) {
            LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
            this._visitables.add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatchExpressions(Collection<LabelSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirementBuilder>();
        }
        for (LabelSelectorRequirement item : items) {
            LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
            this._visitables.add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchExpressions(LabelSelectorRequirement ... items) {
        for (LabelSelectorRequirement item : items) {
            LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
            this._visitables.remove(builder);
            if (this.matchExpressions == null) continue;
            this.matchExpressions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatchExpressions(Collection<LabelSelectorRequirement> items) {
        for (LabelSelectorRequirement item : items) {
            LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
            this._visitables.remove(builder);
            if (this.matchExpressions == null) continue;
            this.matchExpressions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LabelSelectorRequirement> getMatchExpressions() {
        return LabelSelectorFluentImpl.build(this.matchExpressions);
    }

    @Override
    public List<LabelSelectorRequirement> buildMatchExpressions() {
        return LabelSelectorFluentImpl.build(this.matchExpressions);
    }

    @Override
    public LabelSelectorRequirement buildMatchExpression(int index) {
        return this.matchExpressions.get(index).build();
    }

    @Override
    public LabelSelectorRequirement buildFirstMatchExpression() {
        return this.matchExpressions.get(0).build();
    }

    @Override
    public LabelSelectorRequirement buildLastMatchExpression() {
        return this.matchExpressions.get(this.matchExpressions.size() - 1).build();
    }

    @Override
    public LabelSelectorRequirement buildMatchingMatchExpression(Predicate<LabelSelectorRequirementBuilder> predicate) {
        for (LabelSelectorRequirementBuilder item : this.matchExpressions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withMatchExpressions(List<LabelSelectorRequirement> matchExpressions) {
        if (this.matchExpressions != null) {
            this._visitables.removeAll(this.matchExpressions);
        }
        if (matchExpressions != null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirementBuilder>();
            for (LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        } else {
            this.matchExpressions = new ArrayList<LabelSelectorRequirementBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withMatchExpressions(LabelSelectorRequirement ... matchExpressions) {
        if (this.matchExpressions != null) {
            this.matchExpressions.clear();
        }
        if (matchExpressions != null) {
            for (LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatchExpressions() {
        return this.matchExpressions != null && !this.matchExpressions.isEmpty();
    }

    @Override
    public LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpression() {
        return new MatchExpressionsNestedImpl();
    }

    @Override
    public LabelSelectorFluent.MatchExpressionsNested<A> addNewMatchExpressionLike(LabelSelectorRequirement item) {
        return new MatchExpressionsNestedImpl(-1, item);
    }

    @Override
    public LabelSelectorFluent.MatchExpressionsNested<A> setNewMatchExpressionLike(int index, LabelSelectorRequirement item) {
        return new MatchExpressionsNestedImpl(index, item);
    }

    @Override
    public LabelSelectorFluent.MatchExpressionsNested<A> editMatchExpression(int index) {
        if (this.matchExpressions.size() <= index) {
            throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    @Override
    public LabelSelectorFluent.MatchExpressionsNested<A> editFirstMatchExpression() {
        if (this.matchExpressions.size() == 0) {
            throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(0, this.buildMatchExpression(0));
    }

    @Override
    public LabelSelectorFluent.MatchExpressionsNested<A> editLastMatchExpression() {
        int index = this.matchExpressions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    @Override
    public LabelSelectorFluent.MatchExpressionsNested<A> editMatchingMatchExpression(Predicate<LabelSelectorRequirementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchExpressions.size(); ++i) {
            if (!predicate.apply(this.matchExpressions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    @Override
    public A addToMatchLabels(String key, String value) {
        if (this.matchLabels == null && key != null && value != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.matchLabels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null && map != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.matchLabels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchLabels(String key) {
        if (this.matchLabels == null) {
            return (A)this;
        }
        if (key != null && this.matchLabels != null) {
            this.matchLabels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.matchLabels == null) continue;
                this.matchLabels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getMatchLabels() {
        return this.matchLabels;
    }

    @Override
    public A withMatchLabels(Map<String, String> matchLabels) {
        this.matchLabels = matchLabels == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(matchLabels);
        return (A)this;
    }

    @Override
    public Boolean hasMatchLabels() {
        return this.matchLabels != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelSelectorFluentImpl that = (LabelSelectorFluentImpl)o;
        if (this.matchExpressions != null ? !this.matchExpressions.equals(that.matchExpressions) : that.matchExpressions != null) {
            return false;
        }
        return !(this.matchLabels != null ? !this.matchLabels.equals(that.matchLabels) : that.matchLabels != null);
    }

    public class MatchExpressionsNestedImpl<N>
    extends LabelSelectorRequirementFluentImpl<LabelSelectorFluent.MatchExpressionsNested<N>>
    implements LabelSelectorFluent.MatchExpressionsNested<N>,
    Nested<N> {
        private final LabelSelectorRequirementBuilder builder;
        private final int index;

        MatchExpressionsNestedImpl(int index, LabelSelectorRequirement item) {
            this.index = index;
            this.builder = new LabelSelectorRequirementBuilder(this, item);
        }

        MatchExpressionsNestedImpl() {
            this.index = -1;
            this.builder = new LabelSelectorRequirementBuilder(this);
        }

        @Override
        public N and() {
            return (N)LabelSelectorFluentImpl.this.setToMatchExpressions(this.index, this.builder.build());
        }

        @Override
        public N endMatchExpression() {
            return this.and();
        }
    }
}

