/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.NamedCluster;
import io.ap4k.deps.kubernetes.api.model.NamedClusterFluent;
import io.ap4k.deps.kubernetes.api.model.NamedClusterFluentImpl;

public class NamedClusterBuilder
extends NamedClusterFluentImpl<NamedClusterBuilder>
implements VisitableBuilder<NamedCluster, NamedClusterBuilder> {
    NamedClusterFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NamedClusterBuilder() {
        this(true);
    }

    public NamedClusterBuilder(Boolean validationEnabled) {
        this(new NamedCluster(), validationEnabled);
    }

    public NamedClusterBuilder(NamedClusterFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NamedClusterBuilder(NamedClusterFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NamedCluster(), validationEnabled);
    }

    public NamedClusterBuilder(NamedClusterFluent<?> fluent, NamedCluster instance) {
        this(fluent, instance, true);
    }

    public NamedClusterBuilder(NamedClusterFluent<?> fluent, NamedCluster instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCluster(instance.getCluster());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public NamedClusterBuilder(NamedCluster instance) {
        this(instance, (Boolean)true);
    }

    public NamedClusterBuilder(NamedCluster instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCluster(instance.getCluster());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public NamedClusterBuilder(Validator validator) {
        this(new NamedCluster(), (Boolean)true);
    }

    public NamedClusterBuilder(NamedClusterFluent<?> fluent, NamedCluster instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCluster(instance.getCluster());
        fluent.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NamedClusterBuilder(NamedCluster instance, Validator validator) {
        this.fluent = this;
        this.withCluster(instance.getCluster());
        this.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NamedCluster build() {
        NamedCluster buildable = new NamedCluster(this.fluent.getCluster(), this.fluent.getName());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedClusterBuilder that = (NamedClusterBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

