/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.NodeList;
import io.ap4k.deps.kubernetes.api.model.NodeListFluent;
import io.ap4k.deps.kubernetes.api.model.NodeListFluentImpl;

public class NodeListBuilder
extends NodeListFluentImpl<NodeListBuilder>
implements VisitableBuilder<NodeList, NodeListBuilder> {
    NodeListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NodeListBuilder() {
        this(true);
    }

    public NodeListBuilder(Boolean validationEnabled) {
        this(new NodeList(), validationEnabled);
    }

    public NodeListBuilder(NodeListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeListBuilder(NodeListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeList(), validationEnabled);
    }

    public NodeListBuilder(NodeListFluent<?> fluent, NodeList instance) {
        this(fluent, instance, true);
    }

    public NodeListBuilder(NodeListFluent<?> fluent, NodeList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public NodeListBuilder(NodeList instance) {
        this(instance, (Boolean)true);
    }

    public NodeListBuilder(NodeList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public NodeListBuilder(Validator validator) {
        this(new NodeList(), (Boolean)true);
    }

    public NodeListBuilder(NodeListFluent<?> fluent, NodeList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NodeListBuilder(NodeList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NodeList build() {
        NodeList buildable = new NodeList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeListBuilder that = (NodeListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

