/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpec;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpecBuilder;
import io.ap4k.deps.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.ap4k.deps.kubernetes.api.model.ReplicationControllerSpec;
import io.ap4k.deps.kubernetes.api.model.ReplicationControllerSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class ReplicationControllerSpecFluentImpl<A extends ReplicationControllerSpecFluent<A>>
extends BaseFluent<A>
implements ReplicationControllerSpecFluent<A> {
    private Integer minReadySeconds;
    private Integer replicas;
    private Map<String, String> selector;
    private PodTemplateSpecBuilder template;

    public ReplicationControllerSpecFluentImpl() {
    }

    public ReplicationControllerSpecFluentImpl(ReplicationControllerSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    public A withNewMinReadySeconds(String arg1) {
        return this.withMinReadySeconds(new Integer(arg1));
    }

    @Override
    public A withNewMinReadySeconds(int arg1) {
        return this.withMinReadySeconds(new Integer(arg1));
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public A withNewReplicas(String arg1) {
        return this.withReplicas(new Integer(arg1));
    }

    @Override
    public A withNewReplicas(int arg1) {
        return this.withReplicas(new Integer(arg1));
    }

    @Override
    public A addToSelector(String key, String value) {
        if (this.selector == null && key != null && value != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSelector(Map<String, String> map) {
        if (this.selector == null && map != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(String key) {
        if (this.selector == null) {
            return (A)this;
        }
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(Map<String, String> map) {
        if (this.selector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(Map<String, String> selector) {
        this.selector = selector == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(selector);
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public ReplicationControllerSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public ReplicationControllerSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public ReplicationControllerSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public ReplicationControllerSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public ReplicationControllerSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicationControllerSpecFluentImpl that = (ReplicationControllerSpecFluentImpl)o;
        if (this.minReadySeconds != null ? !this.minReadySeconds.equals(that.minReadySeconds) : that.minReadySeconds != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return !(this.template != null ? !this.template.equals(that.template) : that.template != null);
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<ReplicationControllerSpecFluent.TemplateNested<N>>
    implements ReplicationControllerSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ReplicationControllerSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }
}

