/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.model.KeyToPath;
import io.ap4k.deps.kubernetes.api.model.KeyToPathBuilder;
import io.ap4k.deps.kubernetes.api.model.KeyToPathFluentImpl;
import io.ap4k.deps.kubernetes.api.model.SecretVolumeSource;
import io.ap4k.deps.kubernetes.api.model.SecretVolumeSourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SecretVolumeSourceFluentImpl<A extends SecretVolumeSourceFluent<A>>
extends BaseFluent<A>
implements SecretVolumeSourceFluent<A> {
    private Integer defaultMode;
    private List<KeyToPathBuilder> items;
    private Boolean optional;
    private String secretName;

    public SecretVolumeSourceFluentImpl() {
    }

    public SecretVolumeSourceFluentImpl(SecretVolumeSource instance) {
        this.withDefaultMode(instance.getDefaultMode());
        this.withItems(instance.getItems());
        this.withOptional(instance.getOptional());
        this.withSecretName(instance.getSecretName());
    }

    @Override
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    @Override
    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    @Override
    public A withNewDefaultMode(String arg1) {
        return this.withDefaultMode(new Integer(arg1));
    }

    @Override
    public A withNewDefaultMode(int arg1) {
        return this.withDefaultMode(new Integer(arg1));
    }

    @Override
    public A addToItems(int index, KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList<KeyToPathBuilder>();
        }
        KeyToPathBuilder builder = new KeyToPathBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList<KeyToPathBuilder>();
        }
        KeyToPathBuilder builder = new KeyToPathBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(KeyToPath ... items) {
        if (this.items == null) {
            this.items = new ArrayList<KeyToPathBuilder>();
        }
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<KeyToPath> items) {
        if (this.items == null) {
            this.items = new ArrayList<KeyToPathBuilder>();
        }
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(KeyToPath ... items) {
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<KeyToPath> items) {
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<KeyToPath> getItems() {
        return SecretVolumeSourceFluentImpl.build(this.items);
    }

    @Override
    public List<KeyToPath> buildItems() {
        return SecretVolumeSourceFluentImpl.build(this.items);
    }

    @Override
    public KeyToPath buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public KeyToPath buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public KeyToPath buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public KeyToPath buildMatchingItem(Predicate<KeyToPathBuilder> predicate) {
        for (KeyToPathBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withItems(List<KeyToPath> items) {
        if (this.items != null) {
            this._visitables.removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<KeyToPathBuilder>();
            for (KeyToPath item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = new ArrayList<KeyToPathBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withItems(KeyToPath ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (KeyToPath item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public A addNewItem(String key, Integer mode, String path) {
        return this.addToItems(new KeyToPath(key, mode, path));
    }

    @Override
    public SecretVolumeSourceFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public SecretVolumeSourceFluent.ItemsNested<A> addNewItemLike(KeyToPath item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public SecretVolumeSourceFluent.ItemsNested<A> setNewItemLike(int index, KeyToPath item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public SecretVolumeSourceFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public SecretVolumeSourceFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public SecretVolumeSourceFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public SecretVolumeSourceFluent.ItemsNested<A> editMatchingItem(Predicate<KeyToPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public Boolean isOptional() {
        return this.optional;
    }

    @Override
    public A withOptional(Boolean optional) {
        this.optional = optional;
        return (A)this;
    }

    @Override
    public Boolean hasOptional() {
        return this.optional != null;
    }

    @Override
    public A withNewOptional(String arg1) {
        return this.withOptional(new Boolean(arg1));
    }

    @Override
    public A withNewOptional(boolean arg1) {
        return this.withOptional(new Boolean(arg1));
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    @Override
    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretVolumeSourceFluentImpl that = (SecretVolumeSourceFluentImpl)o;
        if (this.defaultMode != null ? !this.defaultMode.equals(that.defaultMode) : that.defaultMode != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.optional != null ? !this.optional.equals(that.optional) : that.optional != null) {
            return false;
        }
        return !(this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null);
    }

    public class ItemsNestedImpl<N>
    extends KeyToPathFluentImpl<SecretVolumeSourceFluent.ItemsNested<N>>
    implements SecretVolumeSourceFluent.ItemsNested<N>,
    Nested<N> {
        private final KeyToPathBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, KeyToPath item) {
            this.index = index;
            this.builder = new KeyToPathBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new KeyToPathBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecretVolumeSourceFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

