/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model.authentication;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.authentication.TokenReviewStatus;
import io.ap4k.deps.kubernetes.api.model.authentication.TokenReviewStatusFluent;
import io.ap4k.deps.kubernetes.api.model.authentication.TokenReviewStatusFluentImpl;

public class TokenReviewStatusBuilder
extends TokenReviewStatusFluentImpl<TokenReviewStatusBuilder>
implements VisitableBuilder<TokenReviewStatus, TokenReviewStatusBuilder> {
    TokenReviewStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TokenReviewStatusBuilder() {
        this(true);
    }

    public TokenReviewStatusBuilder(Boolean validationEnabled) {
        this(new TokenReviewStatus(), validationEnabled);
    }

    public TokenReviewStatusBuilder(TokenReviewStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TokenReviewStatusBuilder(TokenReviewStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TokenReviewStatus(), validationEnabled);
    }

    public TokenReviewStatusBuilder(TokenReviewStatusFluent<?> fluent, TokenReviewStatus instance) {
        this(fluent, instance, true);
    }

    public TokenReviewStatusBuilder(TokenReviewStatusFluent<?> fluent, TokenReviewStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAuthenticated(instance.getAuthenticated());
        fluent.withError(instance.getError());
        fluent.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    public TokenReviewStatusBuilder(TokenReviewStatus instance) {
        this(instance, (Boolean)true);
    }

    public TokenReviewStatusBuilder(TokenReviewStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAuthenticated(instance.getAuthenticated());
        this.withError(instance.getError());
        this.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    public TokenReviewStatusBuilder(Validator validator) {
        this(new TokenReviewStatus(), (Boolean)true);
    }

    public TokenReviewStatusBuilder(TokenReviewStatusFluent<?> fluent, TokenReviewStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAuthenticated(instance.getAuthenticated());
        fluent.withError(instance.getError());
        fluent.withUser(instance.getUser());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public TokenReviewStatusBuilder(TokenReviewStatus instance, Validator validator) {
        this.fluent = this;
        this.withAuthenticated(instance.getAuthenticated());
        this.withError(instance.getError());
        this.withUser(instance.getUser());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public TokenReviewStatus build() {
        TokenReviewStatus buildable = new TokenReviewStatus(this.fluent.isAuthenticated(), this.fluent.getError(), this.fluent.getUser());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenReviewStatusBuilder that = (TokenReviewStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

