/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model.networking;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.networking.IPBlock;
import io.ap4k.deps.kubernetes.api.model.networking.IPBlockFluent;
import io.ap4k.deps.kubernetes.api.model.networking.IPBlockFluentImpl;

public class IPBlockBuilder
extends IPBlockFluentImpl<IPBlockBuilder>
implements VisitableBuilder<IPBlock, IPBlockBuilder> {
    IPBlockFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public IPBlockBuilder() {
        this(true);
    }

    public IPBlockBuilder(Boolean validationEnabled) {
        this(new IPBlock(), validationEnabled);
    }

    public IPBlockBuilder(IPBlockFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IPBlockBuilder(IPBlockFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IPBlock(), validationEnabled);
    }

    public IPBlockBuilder(IPBlockFluent<?> fluent, IPBlock instance) {
        this(fluent, instance, true);
    }

    public IPBlockBuilder(IPBlockFluent<?> fluent, IPBlock instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCidr(instance.getCidr());
        fluent.withExcept(instance.getExcept());
        this.validationEnabled = validationEnabled;
    }

    public IPBlockBuilder(IPBlock instance) {
        this(instance, (Boolean)true);
    }

    public IPBlockBuilder(IPBlock instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCidr(instance.getCidr());
        this.withExcept(instance.getExcept());
        this.validationEnabled = validationEnabled;
    }

    public IPBlockBuilder(Validator validator) {
        this(new IPBlock(), (Boolean)true);
    }

    public IPBlockBuilder(IPBlockFluent<?> fluent, IPBlock instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCidr(instance.getCidr());
        fluent.withExcept(instance.getExcept());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public IPBlockBuilder(IPBlock instance, Validator validator) {
        this.fluent = this;
        this.withCidr(instance.getCidr());
        this.withExcept(instance.getExcept());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public IPBlock build() {
        IPBlock buildable = new IPBlock(this.fluent.getCidr(), this.fluent.getExcept());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IPBlockBuilder that = (IPBlockBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

