/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model.networking;

import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.model.ObjectMeta;
import io.ap4k.deps.kubernetes.api.model.ObjectMetaBuilder;
import io.ap4k.deps.kubernetes.api.model.ObjectMetaFluentImpl;
import io.ap4k.deps.kubernetes.api.model.networking.NetworkPolicy;
import io.ap4k.deps.kubernetes.api.model.networking.NetworkPolicyFluent;
import io.ap4k.deps.kubernetes.api.model.networking.NetworkPolicySpec;
import io.ap4k.deps.kubernetes.api.model.networking.NetworkPolicySpecBuilder;
import io.ap4k.deps.kubernetes.api.model.networking.NetworkPolicySpecFluentImpl;

public class NetworkPolicyFluentImpl<A extends NetworkPolicyFluent<A>>
extends BaseFluent<A>
implements NetworkPolicyFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private NetworkPolicySpecBuilder spec;

    public NetworkPolicyFluentImpl() {
    }

    public NetworkPolicyFluentImpl(NetworkPolicy instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public NetworkPolicyFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public NetworkPolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public NetworkPolicyFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public NetworkPolicyFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public NetworkPolicyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public NetworkPolicySpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public NetworkPolicySpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(NetworkPolicySpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new NetworkPolicySpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public NetworkPolicyFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public NetworkPolicyFluent.SpecNested<A> withNewSpecLike(NetworkPolicySpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public NetworkPolicyFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public NetworkPolicyFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new NetworkPolicySpecBuilder().build());
    }

    @Override
    public NetworkPolicyFluent.SpecNested<A> editOrNewSpecLike(NetworkPolicySpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyFluentImpl that = (NetworkPolicyFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.spec != null ? !this.spec.equals(that.spec) : that.spec != null);
    }

    public class SpecNestedImpl<N>
    extends NetworkPolicySpecFluentImpl<NetworkPolicyFluent.SpecNested<N>>
    implements NetworkPolicyFluent.SpecNested<N>,
    Nested<N> {
        private final NetworkPolicySpecBuilder builder;

        SpecNestedImpl(NetworkPolicySpec item) {
            this.builder = new NetworkPolicySpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new NetworkPolicySpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<NetworkPolicyFluent.MetadataNested<N>>
    implements NetworkPolicyFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

