/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.client;

import io.ap4k.deps.kubernetes.api.model.Service;
import io.ap4k.deps.kubernetes.client.KubernetesClient;
import io.ap4k.deps.kubernetes.client.ServiceToURLProvider;
import io.ap4k.deps.kubernetes.client.utils.URLFromServiceUtil;
import io.ap4k.deps.org.slf4j.Logger;
import io.ap4k.deps.org.slf4j.LoggerFactory;

public class URLFromEnvVarsImpl
implements ServiceToURLProvider {
    public static Logger logger = LoggerFactory.getLogger(URLFromEnvVarsImpl.class);
    public static final String ANNOTATION_EXPOSE_URL = "fabric8.io/exposeUrl";

    @Override
    public String getURL(Service service, String portName, String namespace, KubernetesClient client) {
        String serviceHost = URLFromServiceUtil.resolveHostFromEnvVarOrSystemProperty(service.getMetadata().getName());
        String servicePort = URLFromServiceUtil.resolvePortFromEnvVarOrSystemProperty(service.getMetadata().getName(), "");
        String serviceProtocol = URLFromServiceUtil.resolveProtocolFromEnvVarOrSystemProperty(service.getSpec().getPorts().iterator().next().getProtocol(), "");
        if (!(serviceHost.isEmpty() || servicePort.isEmpty() || serviceProtocol.isEmpty())) {
            return serviceProtocol + "://" + serviceHost + ":" + servicePort;
        }
        String answer = URLFromServiceUtil.getOrCreateAnnotations(service).get(ANNOTATION_EXPOSE_URL);
        if (answer != null && !answer.isEmpty()) {
            return answer;
        }
        return null;
    }

    @Override
    public int getPriority() {
        return ServiceToURLProvider.ServiceToUrlImplPriority.THIRD.getValue();
    }
}

