/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.client;

import io.ap4k.deps.kubernetes.api.model.Service;
import io.ap4k.deps.kubernetes.api.model.ServicePort;
import io.ap4k.deps.kubernetes.api.model.extensions.IngressList;
import io.ap4k.deps.kubernetes.client.KubernetesClient;
import io.ap4k.deps.kubernetes.client.ServiceToURLProvider;
import io.ap4k.deps.kubernetes.client.dsl.NonNamespaceOperation;
import io.ap4k.deps.kubernetes.client.utils.URLFromServiceUtil;

public class URLFromIngressImpl
implements ServiceToURLProvider {
    @Override
    public String getURL(Service service, String portName, String namespace, KubernetesClient client) {
        ServicePort port = URLFromServiceUtil.getServicePortByName(service, portName);
        String serviceName = service.getMetadata().getName();
        if (port == null) {
            throw new RuntimeException("Couldn't find port: " + portName + " for service " + service.getMetadata().getName());
        }
        IngressList ingresses = (IngressList)((NonNamespaceOperation)client.extensions().ingresses().inNamespace(namespace)).list();
        if (ingresses != null && !ingresses.getItems().isEmpty()) {
            return URLFromServiceUtil.getURLFromIngressList(ingresses.getItems(), namespace, serviceName, port);
        }
        return null;
    }

    @Override
    public int getPriority() {
        return ServiceToURLProvider.ServiceToUrlImplPriority.FIRST.getValue();
    }
}

