/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.client;

import io.ap4k.deps.kubernetes.api.model.Node;
import io.ap4k.deps.kubernetes.api.model.NodeAddress;
import io.ap4k.deps.kubernetes.api.model.NodeList;
import io.ap4k.deps.kubernetes.api.model.NodeStatus;
import io.ap4k.deps.kubernetes.api.model.Service;
import io.ap4k.deps.kubernetes.api.model.ServicePort;
import io.ap4k.deps.kubernetes.client.KubernetesClient;
import io.ap4k.deps.kubernetes.client.KubernetesClientException;
import io.ap4k.deps.kubernetes.client.ServiceToURLProvider;
import io.ap4k.deps.kubernetes.client.utils.URLFromServiceUtil;
import io.ap4k.deps.org.slf4j.Logger;
import io.ap4k.deps.org.slf4j.LoggerFactory;
import java.util.Iterator;
import java.util.List;

public class URLFromNodePortImpl
implements ServiceToURLProvider {
    public static Logger logger = LoggerFactory.getLogger(URLFromNodePortImpl.class);

    @Override
    public String getURL(Service service, String portName, String namespace, KubernetesClient client) {
        ServicePort port = URLFromServiceUtil.getServicePortByName(service, portName);
        String serviceProto = port.getProtocol();
        NodePortUrlComponents urlComponents = null;
        Integer nodePort = port.getNodePort();
        if (nodePort != null) {
            try {
                NodeList nodeList = (NodeList)client.nodes().list();
                if (nodeList != null && nodeList.getItems() != null) {
                    Node item;
                    Iterator<Node> iterator = nodeList.getItems().iterator();
                    while (iterator.hasNext() && (urlComponents = this.getUrlComponentsFromNodeList((item = iterator.next()).getStatus(), nodePort)) == null) {
                    }
                }
            }
            catch (KubernetesClientException exception) {
                logger.warn("Could not find a node! " + exception);
            }
        }
        return urlComponents != null ? (serviceProto + "://" + urlComponents.getClusterIP() + ":" + urlComponents.getPortNumber()).toLowerCase() : null;
    }

    private NodePortUrlComponents getUrlComponentsFromNodeList(NodeStatus nodeStatus, Integer nodePort) {
        if (nodeStatus != null) {
            List<NodeAddress> addresses = nodeStatus.getAddresses();
            for (NodeAddress address : addresses) {
                String ip = address.getAddress();
                if (ip.isEmpty()) continue;
                return new NodePortUrlComponents(ip, nodePort);
            }
        }
        return null;
    }

    @Override
    public int getPriority() {
        return ServiceToURLProvider.ServiceToUrlImplPriority.SECOND.getValue();
    }

    private class NodePortUrlComponents {
        private String clusterIP;
        private Integer portNumber;

        public String getClusterIP() {
            return this.clusterIP;
        }

        public Integer getPortNumber() {
            return this.portNumber;
        }

        public NodePortUrlComponents(String clusterIP, Integer portNumber) {
            this.clusterIP = clusterIP;
            this.portNumber = portNumber;
        }
    }
}

