/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.client.dsl.internal;

import io.ap4k.deps.kubernetes.api.builder.TypedVisitor;
import io.ap4k.deps.kubernetes.api.builder.Visitor;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.KubernetesList;
import io.ap4k.deps.kubernetes.api.model.ObjectMetaBuilder;
import io.ap4k.deps.kubernetes.client.Config;
import io.ap4k.deps.kubernetes.client.Handlers;
import io.ap4k.deps.kubernetes.client.HasMetadataVisitiableBuilder;
import io.ap4k.deps.kubernetes.client.KubernetesClientException;
import io.ap4k.deps.kubernetes.client.ResourceHandler;
import io.ap4k.deps.kubernetes.client.Watch;
import io.ap4k.deps.kubernetes.client.Watcher;
import io.ap4k.deps.kubernetes.client.dsl.Applicable;
import io.ap4k.deps.kubernetes.client.dsl.CascadingDeletable;
import io.ap4k.deps.kubernetes.client.dsl.Deletable;
import io.ap4k.deps.kubernetes.client.dsl.Gettable;
import io.ap4k.deps.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.ap4k.deps.kubernetes.client.dsl.Readiable;
import io.ap4k.deps.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.ap4k.deps.kubernetes.client.dsl.Waitable;
import io.ap4k.deps.kubernetes.client.dsl.base.OperationSupport;
import io.ap4k.deps.kubernetes.client.handlers.KubernetesListHandler;
import io.ap4k.deps.kubernetes.client.internal.readiness.Readiness;
import io.ap4k.deps.kubernetes.client.utils.ResourceCompare;
import io.ap4k.deps.kubernetes.client.utils.Utils;
import io.ap4k.deps.okhttp3.OkHttpClient;
import io.ap4k.deps.org.slf4j.Logger;
import io.ap4k.deps.org.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl
extends OperationSupport
implements NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean>,
Waitable<HasMetadata>,
Readiable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.class);
    private final String fallbackNamespace;
    private final String explicitNamespace;
    private final Boolean fromServer;
    private final Boolean deletingExisting;
    private final List<Visitor> visitors;
    private final Object item;
    private final ResourceHandler handler;
    private final long gracePeriodSeconds;
    private final Boolean cascading;

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, InputStream is, Boolean cascading) {
        this(client, config, namespace, explicitNamespace, fromServer, deletingExisting, visitors, NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.unmarshal(is), -1L, cascading);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, Object item, long gracePeriodSeconds, Boolean cascading) {
        super(client, config, null, null, null, null, null);
        this.fallbackNamespace = namespace;
        this.explicitNamespace = explicitNamespace;
        this.fromServer = fromServer;
        this.deletingExisting = deletingExisting;
        this.visitors = visitors != null ? new ArrayList<Visitor>(visitors) : new ArrayList();
        this.item = item;
        this.handler = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item);
        this.cascading = cascading;
        if (this.handler == null) {
            throw new KubernetesClientException("No handler found for object:" + item);
        }
        this.gracePeriodSeconds = gracePeriodSeconds;
        this.visitors.add(new ChangeNamespace(explicitNamespace, this.fallbackNamespace));
    }

    @Override
    public HasMetadata apply() {
        return this.createOrReplace();
    }

    @Override
    public HasMetadata createOrReplace() {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        HasMetadata r = h.reload(this.client, this.config, meta.getMetadata().getNamespace(), meta);
        String namespaceToUse = meta.getMetadata().getNamespace();
        if (r == null) {
            return h.create(this.client, this.config, namespaceToUse, meta);
        }
        if (this.deletingExisting.booleanValue()) {
            Boolean deleted = h.delete(this.client, this.config, namespaceToUse, meta);
            if (!deleted.booleanValue()) {
                throw new KubernetesClientException("Failed to delete existing item:" + meta);
            }
            return h.create(this.client, this.config, namespaceToUse, meta);
        }
        if (ResourceCompare.equals(r, meta)) {
            LOGGER.debug("Item has not changed. Skipping");
            return meta;
        }
        return h.replace(this.client, this.config, namespaceToUse, meta);
    }

    @Override
    public Waitable<HasMetadata> createOrReplaceAnd() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.createOrReplace(), this.gracePeriodSeconds, this.cascading);
    }

    @Override
    public Boolean delete() {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.delete(this.client, this.config, meta.getMetadata().getNamespace(), meta);
    }

    @Override
    public HasMetadata get() {
        if (this.fromServer.booleanValue()) {
            HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
            ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
            HasMetadata reloaded = h.reload(this.client, this.config, meta.getMetadata().getNamespace(), meta);
            if (reloaded != null) {
                HasMetadata edited = reloaded;
                for (Visitor v : this.visitors) {
                    edited = (HasMetadata)((HasMetadataVisitiableBuilder)((HasMetadataVisitiableBuilder)h.edit(edited)).accept(v)).build();
                }
                return edited;
            }
            return null;
        }
        return NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
    }

    @Override
    public VisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> inNamespace(String explicitNamespace) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.item, this.gracePeriodSeconds, this.cascading);
    }

    @Override
    public Gettable<HasMetadata> fromServer() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, true, this.deletingExisting, this.visitors, this.item, this.gracePeriodSeconds, this.cascading);
    }

    @Override
    public Applicable<HasMetadata> deletingExisting() {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.cascading);
    }

    @Override
    public VisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> accept(Visitor visitor) {
        ArrayList<Visitor> newVisitors = new ArrayList<Visitor>(this.visitors);
        newVisitors.add(visitor);
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, newVisitors, this.item, this.gracePeriodSeconds, this.cascading);
    }

    @Override
    public CascadingDeletable<Boolean> withGracePeriod(long gracePeriodSeconds) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, gracePeriodSeconds, this.cascading);
    }

    @Override
    public Deletable<Boolean> cascading(boolean cascading) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, cascading);
    }

    @Override
    public Watch watch(Watcher<HasMetadata> watcher) {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.watch(this.client, this.config, meta.getMetadata().getNamespace(), meta, watcher);
    }

    @Override
    public Watch watch(String resourceVersion, Watcher<HasMetadata> watcher) {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.item), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.watch(this.client, this.config, meta.getMetadata().getNamespace(), meta, watcher);
    }

    @Override
    public Boolean isReady() {
        return Readiness.isReady(this.get());
    }

    @Override
    public HasMetadata waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        HasMetadata meta = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(this.get()), this.visitors);
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta);
        return h.waitUntilReady(this.client, this.config, meta.getMetadata().getNamespace(), meta, amount, timeUnit);
    }

    private static HasMetadata acceptVisitors(HasMetadata item, List<Visitor> visitors) {
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item);
        Object builder = h.edit(item);
        for (Visitor v : visitors) {
            builder.accept(v);
        }
        return (HasMetadata)builder.build();
    }

    private static List<HasMetadata> acceptVisitors(List<HasMetadata> list, List<Visitor> visitors) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        for (HasMetadata item : list) {
            ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item);
            Object builder = h.edit(item);
            for (Visitor v : visitors) {
                builder.accept(v);
            }
            result.add((HasMetadata)builder.build());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> HasMetadata asHasMetadata(T item) {
        if (item instanceof HasMetadata) {
            return (HasMetadata)item;
        }
        if (!(item instanceof String)) throw new IllegalArgumentException("Item needs to be an instance of HasMetadata or String.");
        try (ByteArrayInputStream is = new ByteArrayInputStream(((String)item).getBytes(StandardCharsets.UTF_8));){
            HasMetadata hasMetadata = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.asHasMetadata(NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.unmarshal(is));
            return hasMetadata;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private static <T> ResourceHandler handlerOf(T item) {
        if (item instanceof HasMetadata) {
            return Handlers.get(((HasMetadata)item).getKind());
        }
        if (item instanceof KubernetesList) {
            return new KubernetesListHandler();
        }
        throw new IllegalArgumentException("Could not find a registered handler for item: [" + item + "].");
    }

    private class ChangeNamespace
    extends TypedVisitor<ObjectMetaBuilder> {
        private final String explicitNamespace;
        private final String fallbackNamespace;

        private ChangeNamespace(String explicitNamespace, String fallbackNamespace) {
            this.explicitNamespace = explicitNamespace;
            this.fallbackNamespace = fallbackNamespace;
        }

        @Override
        public void visit(ObjectMetaBuilder builder) {
            if (Utils.isNotNullOrEmpty(this.explicitNamespace)) {
                builder.withNamespace(this.explicitNamespace);
            } else if (Utils.isNullOrEmpty(builder.getNamespace())) {
                builder.withNamespace(this.fallbackNamespace);
            }
        }
    }
}

