/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.client.internal;

import io.ap4k.deps.jackson.core.JsonProcessingException;
import io.ap4k.deps.jackson.databind.ObjectMapper;
import io.ap4k.deps.jackson.dataformat.yaml.YAMLFactory;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.ObjectMeta;
import io.ap4k.deps.kubernetes.api.model.ReplicationController;
import io.ap4k.deps.kubernetes.client.internal.serializationmixins.ObjectMetaMixIn;
import io.ap4k.deps.kubernetes.client.internal.serializationmixins.ReplicationControllerMixIn;

public class SerializationUtils {
    private static ObjectMapper mapper;
    private static ObjectMapper statelessMapper;

    public static ObjectMapper getStatelessMapper() {
        if (statelessMapper == null) {
            statelessMapper = new ObjectMapper(new YAMLFactory());
            statelessMapper.addMixInAnnotations(ObjectMeta.class, ObjectMetaMixIn.class);
            statelessMapper.addMixInAnnotations(ReplicationController.class, ReplicationControllerMixIn.class);
        }
        return statelessMapper;
    }

    public static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper(new YAMLFactory());
        }
        return mapper;
    }

    public static String dumpAsYaml(HasMetadata obj) throws JsonProcessingException {
        return SerializationUtils.getMapper().writeValueAsString(obj);
    }

    public static String dumpWithoutRuntimeStateAsYaml(HasMetadata obj) throws JsonProcessingException {
        return SerializationUtils.getStatelessMapper().writeValueAsString(obj);
    }
}

