/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.client.internal;

import io.ap4k.deps.org.slf4j.Logger;
import io.ap4k.deps.org.slf4j.LoggerFactory;
import java.util.concurrent.ConcurrentHashMap;

public final class VersionUsageUtils {
    private static final Logger LOG = LoggerFactory.getLogger(VersionUsageUtils.class);
    private static ConcurrentHashMap<String, Boolean> UNSTABLE_TYPES = new ConcurrentHashMap();
    private static final boolean LOG_EACH_USAGE = false;

    private VersionUsageUtils() {
    }

    public static void log(String type, String version) {
        if (type == null || version == null) {
            return;
        }
        if (VersionUsageUtils.isUnstable(version) && UNSTABLE_TYPES.putIfAbsent(type + "-" + version, true) == null) {
            VersionUsageUtils.alert(type, version);
        }
    }

    private static boolean isUnstable(String version) {
        String lowerCaseVersion = version.toLowerCase();
        return lowerCaseVersion.contains("beta") || lowerCaseVersion.contains("alpha");
    }

    private static void alert(String type, String version) {
        LOG.warn("The client is using resource type '{}' with unstable version '{}'", (Object)type, (Object)version);
    }
}

