/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.openshift.api.model;

import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.model.ListMeta;
import io.ap4k.deps.kubernetes.api.model.ListMetaBuilder;
import io.ap4k.deps.kubernetes.api.model.ListMetaFluentImpl;
import io.ap4k.deps.openshift.api.model.ImageStream;
import io.ap4k.deps.openshift.api.model.ImageStreamBuilder;
import io.ap4k.deps.openshift.api.model.ImageStreamFluentImpl;
import io.ap4k.deps.openshift.api.model.ImageStreamList;
import io.ap4k.deps.openshift.api.model.ImageStreamListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImageStreamListFluentImpl<A extends ImageStreamListFluent<A>>
extends BaseFluent<A>
implements ImageStreamListFluent<A> {
    private String apiVersion;
    private List<ImageStreamBuilder> items;
    private String kind;
    private ListMetaBuilder metadata;

    public ImageStreamListFluentImpl() {
    }

    public ImageStreamListFluentImpl(ImageStreamList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, ImageStream item) {
        if (this.items == null) {
            this.items = new ArrayList<ImageStreamBuilder>();
        }
        ImageStreamBuilder builder = new ImageStreamBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, ImageStream item) {
        if (this.items == null) {
            this.items = new ArrayList<ImageStreamBuilder>();
        }
        ImageStreamBuilder builder = new ImageStreamBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ImageStream ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ImageStreamBuilder>();
        }
        for (ImageStream item : items) {
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ImageStream> items) {
        if (this.items == null) {
            this.items = new ArrayList<ImageStreamBuilder>();
        }
        for (ImageStream item : items) {
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ImageStream ... items) {
        for (ImageStream item : items) {
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ImageStream> items) {
        for (ImageStream item : items) {
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageStream> getItems() {
        return ImageStreamListFluentImpl.build(this.items);
    }

    @Override
    public List<ImageStream> buildItems() {
        return ImageStreamListFluentImpl.build(this.items);
    }

    @Override
    public ImageStream buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public ImageStream buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ImageStream buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ImageStream buildMatchingItem(Predicate<ImageStreamBuilder> predicate) {
        for (ImageStreamBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withItems(List<ImageStream> items) {
        if (this.items != null) {
            this._visitables.removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ImageStreamBuilder>();
            for (ImageStream item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = new ArrayList<ImageStreamBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withItems(ImageStream ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ImageStream item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> addNewItemLike(ImageStream item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> setNewItemLike(int index, ImageStream item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ImageStreamListFluent.ItemsNested<A> editMatchingItem(Predicate<ImageStreamBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ListMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    @Override
    public ImageStreamListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageStreamListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageStreamListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ImageStreamListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ListMetaBuilder().build());
    }

    @Override
    public ImageStreamListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamListFluentImpl that = (ImageStreamListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<ImageStreamListFluent.MetadataNested<N>>
    implements ImageStreamListFluent.MetadataNested<N>,
    Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends ImageStreamFluentImpl<ImageStreamListFluent.ItemsNested<N>>
    implements ImageStreamListFluent.ItemsNested<N>,
    Nested<N> {
        private final ImageStreamBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, ImageStream item) {
            this.index = index;
            this.builder = new ImageStreamBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ImageStreamBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

