/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.openshift.api.model;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.openshift.api.model.ImageStreamStatus;
import io.ap4k.deps.openshift.api.model.ImageStreamStatusFluent;
import io.ap4k.deps.openshift.api.model.ImageStreamStatusFluentImpl;

public class ImageStreamStatusBuilder
extends ImageStreamStatusFluentImpl<ImageStreamStatusBuilder>
implements VisitableBuilder<ImageStreamStatus, ImageStreamStatusBuilder> {
    ImageStreamStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ImageStreamStatusBuilder() {
        this(true);
    }

    public ImageStreamStatusBuilder(Boolean validationEnabled) {
        this(new ImageStreamStatus(), validationEnabled);
    }

    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageStreamStatus(), validationEnabled);
    }

    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent, ImageStreamStatus instance) {
        this(fluent, instance, true);
    }

    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent, ImageStreamStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDockerImageRepository(instance.getDockerImageRepository());
        fluent.withPublicDockerImageRepository(instance.getPublicDockerImageRepository());
        fluent.withTags(instance.getTags());
        this.validationEnabled = validationEnabled;
    }

    public ImageStreamStatusBuilder(ImageStreamStatus instance) {
        this(instance, (Boolean)true);
    }

    public ImageStreamStatusBuilder(ImageStreamStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withPublicDockerImageRepository(instance.getPublicDockerImageRepository());
        this.withTags(instance.getTags());
        this.validationEnabled = validationEnabled;
    }

    public ImageStreamStatusBuilder(Validator validator) {
        this(new ImageStreamStatus(), (Boolean)true);
    }

    public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent, ImageStreamStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withDockerImageRepository(instance.getDockerImageRepository());
        fluent.withPublicDockerImageRepository(instance.getPublicDockerImageRepository());
        fluent.withTags(instance.getTags());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ImageStreamStatusBuilder(ImageStreamStatus instance, Validator validator) {
        this.fluent = this;
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withPublicDockerImageRepository(instance.getPublicDockerImageRepository());
        this.withTags(instance.getTags());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ImageStreamStatus build() {
        ImageStreamStatus buildable = new ImageStreamStatus(this.fluent.getDockerImageRepository(), this.fluent.getPublicDockerImageRepository(), this.fluent.getTags());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamStatusBuilder that = (ImageStreamStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

