/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.openshift.api.model;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.openshift.api.model.Project;
import io.ap4k.deps.openshift.api.model.ProjectFluent;
import io.ap4k.deps.openshift.api.model.ProjectFluentImpl;

public class ProjectBuilder
extends ProjectFluentImpl<ProjectBuilder>
implements VisitableBuilder<Project, ProjectBuilder> {
    ProjectFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ProjectBuilder() {
        this(true);
    }

    public ProjectBuilder(Boolean validationEnabled) {
        this(new Project(), validationEnabled);
    }

    public ProjectBuilder(ProjectFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ProjectBuilder(ProjectFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Project(), validationEnabled);
    }

    public ProjectBuilder(ProjectFluent<?> fluent, Project instance) {
        this(fluent, instance, true);
    }

    public ProjectBuilder(ProjectFluent<?> fluent, Project instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ProjectBuilder(Project instance) {
        this(instance, (Boolean)true);
    }

    public ProjectBuilder(Project instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ProjectBuilder(Validator validator) {
        this(new Project(), (Boolean)true);
    }

    public ProjectBuilder(ProjectFluent<?> fluent, Project instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ProjectBuilder(Project instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Project build() {
        Project buildable = new Project(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectBuilder that = (ProjectBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

