/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.openshift.client;

import io.ap4k.deps.kubernetes.api.model.ComponentStatus;
import io.ap4k.deps.kubernetes.api.model.ComponentStatusList;
import io.ap4k.deps.kubernetes.api.model.ConfigMap;
import io.ap4k.deps.kubernetes.api.model.ConfigMapList;
import io.ap4k.deps.kubernetes.api.model.Doneable;
import io.ap4k.deps.kubernetes.api.model.DoneableComponentStatus;
import io.ap4k.deps.kubernetes.api.model.DoneableConfigMap;
import io.ap4k.deps.kubernetes.api.model.DoneableEndpoints;
import io.ap4k.deps.kubernetes.api.model.DoneableEvent;
import io.ap4k.deps.kubernetes.api.model.DoneableLimitRange;
import io.ap4k.deps.kubernetes.api.model.DoneableNamespace;
import io.ap4k.deps.kubernetes.api.model.DoneableNode;
import io.ap4k.deps.kubernetes.api.model.DoneablePersistentVolume;
import io.ap4k.deps.kubernetes.api.model.DoneablePersistentVolumeClaim;
import io.ap4k.deps.kubernetes.api.model.DoneablePod;
import io.ap4k.deps.kubernetes.api.model.DoneableReplicationController;
import io.ap4k.deps.kubernetes.api.model.DoneableResourceQuota;
import io.ap4k.deps.kubernetes.api.model.DoneableSecret;
import io.ap4k.deps.kubernetes.api.model.DoneableService;
import io.ap4k.deps.kubernetes.api.model.DoneableServiceAccount;
import io.ap4k.deps.kubernetes.api.model.Endpoints;
import io.ap4k.deps.kubernetes.api.model.EndpointsList;
import io.ap4k.deps.kubernetes.api.model.Event;
import io.ap4k.deps.kubernetes.api.model.EventList;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.KubernetesList;
import io.ap4k.deps.kubernetes.api.model.KubernetesResourceList;
import io.ap4k.deps.kubernetes.api.model.LimitRange;
import io.ap4k.deps.kubernetes.api.model.LimitRangeList;
import io.ap4k.deps.kubernetes.api.model.Namespace;
import io.ap4k.deps.kubernetes.api.model.NamespaceList;
import io.ap4k.deps.kubernetes.api.model.Node;
import io.ap4k.deps.kubernetes.api.model.NodeList;
import io.ap4k.deps.kubernetes.api.model.PersistentVolume;
import io.ap4k.deps.kubernetes.api.model.PersistentVolumeClaim;
import io.ap4k.deps.kubernetes.api.model.PersistentVolumeClaimList;
import io.ap4k.deps.kubernetes.api.model.PersistentVolumeList;
import io.ap4k.deps.kubernetes.api.model.Pod;
import io.ap4k.deps.kubernetes.api.model.PodList;
import io.ap4k.deps.kubernetes.api.model.ReplicationController;
import io.ap4k.deps.kubernetes.api.model.ReplicationControllerList;
import io.ap4k.deps.kubernetes.api.model.ResourceQuota;
import io.ap4k.deps.kubernetes.api.model.ResourceQuotaList;
import io.ap4k.deps.kubernetes.api.model.RootPaths;
import io.ap4k.deps.kubernetes.api.model.Secret;
import io.ap4k.deps.kubernetes.api.model.SecretList;
import io.ap4k.deps.kubernetes.api.model.Service;
import io.ap4k.deps.kubernetes.api.model.ServiceAccount;
import io.ap4k.deps.kubernetes.api.model.ServiceAccountList;
import io.ap4k.deps.kubernetes.api.model.ServiceList;
import io.ap4k.deps.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.ap4k.deps.kubernetes.api.model.apiextensions.CustomResourceDefinitionList;
import io.ap4k.deps.kubernetes.api.model.apiextensions.DoneableCustomResourceDefinition;
import io.ap4k.deps.kubernetes.client.AppsAPIGroupClient;
import io.ap4k.deps.kubernetes.client.AutoscalingAPIGroupClient;
import io.ap4k.deps.kubernetes.client.BaseClient;
import io.ap4k.deps.kubernetes.client.BatchAPIGroupClient;
import io.ap4k.deps.kubernetes.client.Config;
import io.ap4k.deps.kubernetes.client.DefaultKubernetesClient;
import io.ap4k.deps.kubernetes.client.ExtensionsAPIGroupClient;
import io.ap4k.deps.kubernetes.client.KubernetesClientException;
import io.ap4k.deps.kubernetes.client.NamespacedKubernetesClient;
import io.ap4k.deps.kubernetes.client.NetworkAPIGroupClient;
import io.ap4k.deps.kubernetes.client.RbacAPIGroupClient;
import io.ap4k.deps.kubernetes.client.RequestConfig;
import io.ap4k.deps.kubernetes.client.StorageAPIGroupClient;
import io.ap4k.deps.kubernetes.client.VersionInfo;
import io.ap4k.deps.kubernetes.client.WithRequestCallable;
import io.ap4k.deps.kubernetes.client.dsl.AppsAPIGroupDSL;
import io.ap4k.deps.kubernetes.client.dsl.AutoscalingAPIGroupDSL;
import io.ap4k.deps.kubernetes.client.dsl.BatchAPIGroupDSL;
import io.ap4k.deps.kubernetes.client.dsl.FunctionCallable;
import io.ap4k.deps.kubernetes.client.dsl.KubernetesListMixedOperation;
import io.ap4k.deps.kubernetes.client.dsl.LogWatch;
import io.ap4k.deps.kubernetes.client.dsl.MixedOperation;
import io.ap4k.deps.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.ap4k.deps.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.ap4k.deps.kubernetes.client.dsl.NetworkAPIGroupDSL;
import io.ap4k.deps.kubernetes.client.dsl.NonNamespaceOperation;
import io.ap4k.deps.kubernetes.client.dsl.ParameterMixedOperation;
import io.ap4k.deps.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.ap4k.deps.kubernetes.client.dsl.PodResource;
import io.ap4k.deps.kubernetes.client.dsl.RbacAPIGroupDSL;
import io.ap4k.deps.kubernetes.client.dsl.Resource;
import io.ap4k.deps.kubernetes.client.dsl.RollableScalableResource;
import io.ap4k.deps.kubernetes.client.dsl.ServiceResource;
import io.ap4k.deps.kubernetes.client.dsl.StorageAPIGroupDSL;
import io.ap4k.deps.kubernetes.client.dsl.internal.ClusterOperationsImpl;
import io.ap4k.deps.kubernetes.client.dsl.internal.ComponentStatusOperationsImpl;
import io.ap4k.deps.kubernetes.client.dsl.internal.CustomResourceDefinitionOperationsImpl;
import io.ap4k.deps.kubernetes.client.dsl.internal.CustomResourceOperationsImpl;
import io.ap4k.deps.kubernetes.client.utils.BackwardsCompatibilityInterceptor;
import io.ap4k.deps.kubernetes.client.utils.ImpersonatorInterceptor;
import io.ap4k.deps.kubernetes.client.utils.Serialization;
import io.ap4k.deps.okhttp3.Authenticator;
import io.ap4k.deps.okhttp3.OkHttpClient;
import io.ap4k.deps.openshift.api.model.Build;
import io.ap4k.deps.openshift.api.model.BuildConfig;
import io.ap4k.deps.openshift.api.model.BuildConfigList;
import io.ap4k.deps.openshift.api.model.BuildList;
import io.ap4k.deps.openshift.api.model.ClusterRoleBinding;
import io.ap4k.deps.openshift.api.model.ClusterRoleBindingList;
import io.ap4k.deps.openshift.api.model.DeploymentConfig;
import io.ap4k.deps.openshift.api.model.DeploymentConfigList;
import io.ap4k.deps.openshift.api.model.DoneableBuild;
import io.ap4k.deps.openshift.api.model.DoneableBuildConfig;
import io.ap4k.deps.openshift.api.model.DoneableClusterRoleBinding;
import io.ap4k.deps.openshift.api.model.DoneableDeploymentConfig;
import io.ap4k.deps.openshift.api.model.DoneableGroup;
import io.ap4k.deps.openshift.api.model.DoneableImageStream;
import io.ap4k.deps.openshift.api.model.DoneableImageStreamTag;
import io.ap4k.deps.openshift.api.model.DoneableOAuthAccessToken;
import io.ap4k.deps.openshift.api.model.DoneableOAuthAuthorizeToken;
import io.ap4k.deps.openshift.api.model.DoneableOAuthClient;
import io.ap4k.deps.openshift.api.model.DoneablePolicy;
import io.ap4k.deps.openshift.api.model.DoneablePolicyBinding;
import io.ap4k.deps.openshift.api.model.DoneableProject;
import io.ap4k.deps.openshift.api.model.DoneableRole;
import io.ap4k.deps.openshift.api.model.DoneableRoleBinding;
import io.ap4k.deps.openshift.api.model.DoneableRoute;
import io.ap4k.deps.openshift.api.model.DoneableSecurityContextConstraints;
import io.ap4k.deps.openshift.api.model.DoneableTemplate;
import io.ap4k.deps.openshift.api.model.DoneableUser;
import io.ap4k.deps.openshift.api.model.Group;
import io.ap4k.deps.openshift.api.model.GroupList;
import io.ap4k.deps.openshift.api.model.ImageStream;
import io.ap4k.deps.openshift.api.model.ImageStreamList;
import io.ap4k.deps.openshift.api.model.ImageStreamTag;
import io.ap4k.deps.openshift.api.model.ImageStreamTagList;
import io.ap4k.deps.openshift.api.model.OAuthAccessToken;
import io.ap4k.deps.openshift.api.model.OAuthAccessTokenList;
import io.ap4k.deps.openshift.api.model.OAuthAuthorizeToken;
import io.ap4k.deps.openshift.api.model.OAuthAuthorizeTokenList;
import io.ap4k.deps.openshift.api.model.OAuthClient;
import io.ap4k.deps.openshift.api.model.OAuthClientList;
import io.ap4k.deps.openshift.api.model.Policy;
import io.ap4k.deps.openshift.api.model.PolicyBinding;
import io.ap4k.deps.openshift.api.model.PolicyBindingList;
import io.ap4k.deps.openshift.api.model.PolicyList;
import io.ap4k.deps.openshift.api.model.Project;
import io.ap4k.deps.openshift.api.model.ProjectList;
import io.ap4k.deps.openshift.api.model.Role;
import io.ap4k.deps.openshift.api.model.RoleBinding;
import io.ap4k.deps.openshift.api.model.RoleBindingList;
import io.ap4k.deps.openshift.api.model.RoleList;
import io.ap4k.deps.openshift.api.model.Route;
import io.ap4k.deps.openshift.api.model.RouteList;
import io.ap4k.deps.openshift.api.model.SecurityContextConstraints;
import io.ap4k.deps.openshift.api.model.SecurityContextConstraintsList;
import io.ap4k.deps.openshift.api.model.Template;
import io.ap4k.deps.openshift.api.model.TemplateList;
import io.ap4k.deps.openshift.api.model.User;
import io.ap4k.deps.openshift.api.model.UserList;
import io.ap4k.deps.openshift.client.NamespacedOpenShiftClient;
import io.ap4k.deps.openshift.client.OpenShiftConfig;
import io.ap4k.deps.openshift.client.OpenShiftConfigBuilder;
import io.ap4k.deps.openshift.client.dsl.BuildConfigResource;
import io.ap4k.deps.openshift.client.dsl.BuildResource;
import io.ap4k.deps.openshift.client.dsl.CreateableLocalSubjectAccessReview;
import io.ap4k.deps.openshift.client.dsl.CreateableSubjectAccessReview;
import io.ap4k.deps.openshift.client.dsl.DeployableScalableResource;
import io.ap4k.deps.openshift.client.dsl.ProjectRequestOperation;
import io.ap4k.deps.openshift.client.dsl.SubjectAccessReviewOperation;
import io.ap4k.deps.openshift.client.dsl.TemplateResource;
import io.ap4k.deps.openshift.client.dsl.internal.BuildConfigOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.BuildOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.ClusterRoleBindingOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.DeploymentConfigOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.GroupOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.ImageStreamOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.ImageStreamTagOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.OAuthAccessTokenOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.OAuthAuthorizeTokenOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.OAuthClientOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.PolicyBindingOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.PolicyOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.ProjectOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.ProjectRequestsOperationImpl;
import io.ap4k.deps.openshift.client.dsl.internal.RoleBindingOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.RoleOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.RouteOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.SecurityContextConstraintsOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.SubjectAccessReviewOperationImpl;
import io.ap4k.deps.openshift.client.dsl.internal.TemplateOperationsImpl;
import io.ap4k.deps.openshift.client.dsl.internal.UserOperationsImpl;
import io.ap4k.deps.openshift.client.internal.OpenShiftOAuthInterceptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class DefaultOpenShiftClient
extends BaseClient
implements NamespacedOpenShiftClient {
    private URL openShiftUrl;
    private NamespacedKubernetesClient delegate;

    public DefaultOpenShiftClient() throws KubernetesClientException {
        this(new OpenShiftConfigBuilder().build());
    }

    public DefaultOpenShiftClient(String masterUrl) throws KubernetesClientException {
        this(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public DefaultOpenShiftClient(Config config) throws KubernetesClientException {
        this(new OpenShiftConfig(config));
    }

    public DefaultOpenShiftClient(OpenShiftConfig config) throws KubernetesClientException {
        super(config);
        try {
            this.httpClient = this.clientWithOpenShiftOAuthInterceptor(this.httpClient);
            this.delegate = new DefaultKubernetesClient(this.httpClient, config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    public DefaultOpenShiftClient(OkHttpClient httpClient, OpenShiftConfig config) throws KubernetesClientException {
        super(httpClient, config);
        try {
            this.httpClient = this.clientWithOpenShiftOAuthInterceptor(httpClient);
            this.delegate = new DefaultKubernetesClient(this.httpClient, config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    public static DefaultOpenShiftClient fromConfig(String config) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(config, OpenShiftConfig.class));
    }

    public static DefaultOpenShiftClient fromConfig(InputStream is) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(is, OpenShiftConfig.class));
    }

    private OkHttpClient clientWithOpenShiftOAuthInterceptor(OkHttpClient httpClient) {
        httpClient = httpClient.newBuilder().authenticator(Authenticator.NONE).build();
        OkHttpClient.Builder builder = httpClient.newBuilder();
        builder.interceptors().clear();
        return builder.addInterceptor(new OpenShiftOAuthInterceptor(httpClient, OpenShiftConfig.wrap(this.getConfiguration()))).addInterceptor(new ImpersonatorInterceptor(this.getConfiguration())).addInterceptor(new BackwardsCompatibilityInterceptor()).build();
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.openShiftUrl;
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata item) {
        return this.delegate.resource(item);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(HasMetadata ... items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<Service, ServiceList, DoneableService, ServiceResource<Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResources(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return new CustomResourceOperationsImpl<T, L, D>(this.httpClient, this.getConfiguration(), crd, resourceType, listClass, doneClass);
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResource(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return this.customResources(crd, resourceType, listClass, doneClass);
    }

    @Override
    public NonNamespaceOperation<CustomResourceDefinition, CustomResourceDefinitionList, DoneableCustomResourceDefinition, Resource<CustomResourceDefinition, DoneableCustomResourceDefinition>> customResourceDefinitions() {
        return new CustomResourceDefinitionOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Build, BuildList, DoneableBuild, BuildResource<Build, DoneableBuild, String, LogWatch>> builds() {
        return new BuildOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>> buildConfigs() {
        return new BuildConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig>> deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    public MixedOperation<Group, GroupList, DoneableGroup, Resource<Group, DoneableGroup>> groups() {
        return new GroupOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, DoneableImageStream, Resource<ImageStream, DoneableImageStream>> imageStreams() {
        return new ImageStreamOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, DoneableImageStreamTag, Resource<ImageStreamTag, DoneableImageStreamTag>> imageStreamTags() {
        return new ImageStreamTagOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, DoneableOAuthAccessToken, Resource<OAuthAccessToken, DoneableOAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, DoneableOAuthAuthorizeToken, Resource<OAuthAuthorizeToken, DoneableOAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, DoneableOAuthClient, Resource<OAuthClient, DoneableOAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<Policy, PolicyList, DoneablePolicy, Resource<Policy, DoneablePolicy>> policies() {
        return new PolicyOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<PolicyBinding, PolicyBindingList, DoneablePolicyBinding, Resource<PolicyBinding, DoneablePolicyBinding>> policyBindings() {
        return new PolicyBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public NonNamespaceOperation<Project, ProjectList, DoneableProject, Resource<Project, DoneableProject>> projects() {
        return new ProjectOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, Resource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return new SecurityContextConstraintsOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return new ProjectRequestsOperationImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<Role, RoleList, DoneableRole, Resource<Role, DoneableRole>> roles() {
        return new RoleOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<RoleBinding, RoleBindingList, DoneableRoleBinding, Resource<RoleBinding, DoneableRoleBinding>> roleBindings() {
        return new RoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<Route, RouteList, DoneableRoute, Resource<Route, DoneableRoute>> routes() {
        return new RouteOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public ParameterMixedOperation<Template, TemplateList, DoneableTemplate, TemplateResource<Template, KubernetesList, DoneableTemplate>> templates() {
        return new TemplateOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    public MixedOperation<User, UserList, DoneableUser, Resource<User, DoneableUser>> users() {
        return new UserOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public SubjectAccessReviewOperation<CreateableSubjectAccessReview, CreateableLocalSubjectAccessReview> subjectAccessReviews() {
        return new SubjectAccessReviewOperationImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), null, this.getNamespace());
    }

    @Override
    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, DoneableClusterRoleBinding, Resource<ClusterRoleBinding, DoneableClusterRoleBinding>> clusterRoleBindings() {
        return new ClusterRoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public NamespacedOpenShiftClient inNamespace(String namespace) {
        OpenShiftConfig updated = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(new OpenShiftConfig(this.getConfiguration())).withOpenShiftUrl(this.openShiftUrl.toString())).withNamespace(namespace)).build();
        return new DefaultOpenShiftClient(this.httpClient, updated);
    }

    @Override
    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupClient extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        return new ClusterOperationsImpl(this.httpClient, this.getConfiguration(), "version/openshift").fetchVersion();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.adapt(AppsAPIGroupClient.class);
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.adapt(AutoscalingAPIGroupClient.class);
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.adapt(NetworkAPIGroupClient.class);
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.adapt(StorageAPIGroupClient.class);
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.adapt(BatchAPIGroupClient.class);
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.adapt(RbacAPIGroupClient.class);
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedOpenShiftClient>(this, requestConfig);
    }

    @Override
    public User currentUser() {
        return (User)((Resource)this.users().withName("~")).get();
    }

    @Override
    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        List<String> paths;
        String apiGroupPath = "/apis/" + apiGroup;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path) && !Objects.equals(apiGroupPath, path)) continue;
                return true;
            }
        }
        return false;
    }
}

