/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.openshift.client;

import io.ap4k.deps.kubernetes.api.model.RootPaths;
import io.ap4k.deps.kubernetes.api.model.Service;
import io.ap4k.deps.kubernetes.api.model.ServicePort;
import io.ap4k.deps.kubernetes.client.KubernetesClient;
import io.ap4k.deps.kubernetes.client.KubernetesClientException;
import io.ap4k.deps.kubernetes.client.ServiceToURLProvider;
import io.ap4k.deps.kubernetes.client.dsl.NonNamespaceOperation;
import io.ap4k.deps.kubernetes.client.dsl.Resource;
import io.ap4k.deps.kubernetes.client.utils.URLFromServiceUtil;
import io.ap4k.deps.openshift.api.model.Route;
import io.ap4k.deps.openshift.client.OpenShiftClient;
import io.ap4k.deps.org.slf4j.Logger;
import io.ap4k.deps.org.slf4j.LoggerFactory;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class URLFromOpenshiftRouteImpl
implements ServiceToURLProvider {
    public static final Logger logger = LoggerFactory.getLogger(URLFromOpenshiftRouteImpl.class);
    private final ConcurrentMap<URL, Boolean> IS_OPENSHIFT = new ConcurrentHashMap<URL, Boolean>();

    @Override
    public String getURL(Service service, String portName, String namespace, KubernetesClient client) {
        block4: {
            String serviceName = service.getMetadata().getName();
            ServicePort port = URLFromServiceUtil.getServicePortByName(service, portName);
            if (port != null && port.getName() != null && this.isOpenShift(client)) {
                try {
                    String serviceProtocol = port.getProtocol();
                    OpenShiftClient openShiftClient = client.adapt(OpenShiftClient.class);
                    Route route = (Route)((Resource)((NonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).withName(service.getMetadata().getName())).get();
                    if (route != null) {
                        return (serviceProtocol + "://" + route.getSpec().getHost()).toLowerCase();
                    }
                }
                catch (KubernetesClientException e) {
                    if (e.getCode() != 403) break block4;
                    logger.warn("Could not lookup route:" + serviceName + " in namespace:" + namespace + ", due to: " + e.getMessage());
                }
            }
        }
        return null;
    }

    @Override
    public int getPriority() {
        return ServiceToURLProvider.ServiceToUrlImplPriority.FOURTH.getValue();
    }

    public boolean isOpenShift(KubernetesClient client) {
        List<String> paths;
        URL masterUrl = client.getMasterUrl();
        if (this.IS_OPENSHIFT.containsKey(masterUrl)) {
            return (Boolean)this.IS_OPENSHIFT.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path)) continue;
                this.IS_OPENSHIFT.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        this.IS_OPENSHIFT.putIfAbsent(masterUrl, false);
        return false;
    }
}

