/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.openshift.client.dsl.internal;

import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.client.KubernetesClientException;
import io.ap4k.deps.kubernetes.client.dsl.base.OperationSupport;
import io.ap4k.deps.kubernetes.client.utils.Utils;
import io.ap4k.deps.okhttp3.OkHttpClient;
import io.ap4k.deps.openshift.api.model.LocalSubjectAccessReview;
import io.ap4k.deps.openshift.api.model.LocalSubjectAccessReviewBuilder;
import io.ap4k.deps.openshift.api.model.SubjectAccessReview;
import io.ap4k.deps.openshift.api.model.SubjectAccessReviewBuilder;
import io.ap4k.deps.openshift.api.model.SubjectAccessReviewResponse;
import io.ap4k.deps.openshift.client.OpenShiftConfig;
import io.ap4k.deps.openshift.client.dsl.CreateableLocalSubjectAccessReview;
import io.ap4k.deps.openshift.client.dsl.CreateableSubjectAccessReview;
import io.ap4k.deps.openshift.client.dsl.SubjectAccessReviewOperation;
import io.ap4k.deps.openshift.client.dsl.internal.OpenShiftOperation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;

public class SubjectAccessReviewOperationImpl
extends OperationSupport
implements SubjectAccessReviewOperation<CreateableSubjectAccessReview, CreateableLocalSubjectAccessReview> {
    public SubjectAccessReviewOperationImpl(OkHttpClient client, OpenShiftConfig config) {
        this(client, config, null, null);
    }

    public SubjectAccessReviewOperationImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace) {
        super(client, OpenShiftOperation.withApiGroup(client, "authorization.openshift.io", apiVersion, config), "subjectaccessreviews", namespace, null);
    }

    @Override
    public CreateableLocalSubjectAccessReview inNamespace(String namespace) {
        return new SubjectAccessReviewOperationImpl(this.client, OpenShiftConfig.wrap(this.getConfig()), null, namespace).local();
    }

    public SubjectAccessReviewResponse create(SubjectAccessReview ... item) {
        return new CreateableSubjectAccessReviewImpl(this.client).create(item);
    }

    @Override
    public CreateableSubjectAccessReview createNew() {
        return new CreateableSubjectAccessReviewImpl(this.client).createNew();
    }

    @Override
    public URL getRootUrl() {
        try {
            return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private CreateableLocalSubjectAccessReview local() {
        return new CreateableLocalSubjectAccessReviewImpl(this.client);
    }

    @Override
    protected <T> String checkNamespace(T item) {
        String itemNs;
        String operationNs = this.getNamespace();
        String string = itemNs = item instanceof HasMetadata && ((HasMetadata)item).getMetadata() != null ? ((HasMetadata)item).getMetadata().getNamespace() : null;
        if (Utils.isNullOrEmpty(operationNs) && Utils.isNullOrEmpty(itemNs)) {
            return null;
        }
        if (Utils.isNullOrEmpty(itemNs)) {
            return operationNs;
        }
        if (Utils.isNullOrEmpty(operationNs)) {
            return itemNs;
        }
        if (itemNs.equals(operationNs)) {
            return itemNs;
        }
        throw new KubernetesClientException("Namespace mismatch. Item namespace:" + itemNs + ". Operation namespace:" + operationNs + ".");
    }

    private class CreateableSubjectAccessReviewImpl
    extends CreateableSubjectAccessReview {
        private final OkHttpClient client;
        private final SubjectAccessReviewBuilder builder;

        private CreateableSubjectAccessReviewImpl(OkHttpClient client) {
            this.client = client;
            this.builder = new SubjectAccessReviewBuilder(this);
        }

        private CreateableSubjectAccessReviewImpl(OkHttpClient client, SubjectAccessReviewBuilder builder) {
            this.client = client;
            this.builder = builder;
        }

        public SubjectAccessReviewResponse create(SubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SubjectAccessReviewResponse)SubjectAccessReviewOperationImpl.this.handleCreate(resources[0], SubjectAccessReviewResponse.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        @Override
        public CreateableSubjectAccessReview createNew() {
            return this;
        }

        @Override
        public SubjectAccessReviewResponse done() {
            return this.create(this.builder.build());
        }
    }

    private class CreateableLocalSubjectAccessReviewImpl
    extends CreateableLocalSubjectAccessReview {
        private final OkHttpClient client;
        private final LocalSubjectAccessReviewBuilder builder;

        private CreateableLocalSubjectAccessReviewImpl(OkHttpClient client) {
            this.client = client;
            this.builder = new LocalSubjectAccessReviewBuilder(this);
        }

        private CreateableLocalSubjectAccessReviewImpl(OkHttpClient client, LocalSubjectAccessReviewBuilder builder) {
            this.client = client;
            this.builder = builder;
        }

        public SubjectAccessReviewResponse create(LocalSubjectAccessReview ... resources) {
            try {
                if (resources.length > 1) {
                    throw new IllegalArgumentException("Too many items to create.");
                }
                if (resources.length == 1) {
                    return (SubjectAccessReviewResponse)SubjectAccessReviewOperationImpl.this.handleCreate(resources[0], SubjectAccessReviewResponse.class);
                }
                throw new IllegalArgumentException("Nothing to create.");
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        @Override
        public CreateableLocalSubjectAccessReview createNew() {
            return this;
        }

        @Override
        public SubjectAccessReviewResponse done() {
            return this.create(this.builder.build());
        }
    }
}

