/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.servicecatalog.api.model;

import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.model.ListMeta;
import io.ap4k.deps.servicecatalog.api.model.ServiceBinding;
import io.ap4k.deps.servicecatalog.api.model.ServiceBindingBuilder;
import io.ap4k.deps.servicecatalog.api.model.ServiceBindingFluentImpl;
import io.ap4k.deps.servicecatalog.api.model.ServiceBindingList;
import io.ap4k.deps.servicecatalog.api.model.ServiceBindingListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServiceBindingListFluentImpl<A extends ServiceBindingListFluent<A>>
extends BaseFluent<A>
implements ServiceBindingListFluent<A> {
    private String apiVersion;
    private List<ServiceBindingBuilder> items;
    private String kind;
    private ListMeta metadata;

    public ServiceBindingListFluentImpl() {
    }

    public ServiceBindingListFluentImpl(ServiceBindingList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, ServiceBinding item) {
        if (this.items == null) {
            this.items = new ArrayList<ServiceBindingBuilder>();
        }
        ServiceBindingBuilder builder = new ServiceBindingBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, ServiceBinding item) {
        if (this.items == null) {
            this.items = new ArrayList<ServiceBindingBuilder>();
        }
        ServiceBindingBuilder builder = new ServiceBindingBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ServiceBinding ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ServiceBindingBuilder>();
        }
        for (ServiceBinding item : items) {
            ServiceBindingBuilder builder = new ServiceBindingBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ServiceBinding> items) {
        if (this.items == null) {
            this.items = new ArrayList<ServiceBindingBuilder>();
        }
        for (ServiceBinding item : items) {
            ServiceBindingBuilder builder = new ServiceBindingBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ServiceBinding ... items) {
        for (ServiceBinding item : items) {
            ServiceBindingBuilder builder = new ServiceBindingBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ServiceBinding> items) {
        for (ServiceBinding item : items) {
            ServiceBindingBuilder builder = new ServiceBindingBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServiceBinding> getItems() {
        return ServiceBindingListFluentImpl.build(this.items);
    }

    @Override
    public List<ServiceBinding> buildItems() {
        return ServiceBindingListFluentImpl.build(this.items);
    }

    @Override
    public ServiceBinding buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public ServiceBinding buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ServiceBinding buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ServiceBinding buildMatchingItem(Predicate<ServiceBindingBuilder> predicate) {
        for (ServiceBindingBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ServiceBindingBuilder> predicate) {
        for (ServiceBindingBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ServiceBinding> items) {
        if (this.items != null) {
            this._visitables.removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ServiceBindingBuilder>();
            for (ServiceBinding item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = new ArrayList<ServiceBindingBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withItems(ServiceBinding ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ServiceBinding item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ServiceBindingListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ServiceBindingListFluent.ItemsNested<A> addNewItemLike(ServiceBinding item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ServiceBindingListFluent.ItemsNested<A> setNewItemLike(int index, ServiceBinding item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ServiceBindingListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ServiceBindingListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ServiceBindingListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ServiceBindingListFluent.ItemsNested<A> editMatchingItem(Predicate<ServiceBindingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBindingListFluentImpl that = (ServiceBindingListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class ItemsNestedImpl<N>
    extends ServiceBindingFluentImpl<ServiceBindingListFluent.ItemsNested<N>>
    implements ServiceBindingListFluent.ItemsNested<N>,
    Nested<N> {
        private final ServiceBindingBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, ServiceBinding item) {
            this.index = index;
            this.builder = new ServiceBindingBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ServiceBindingBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

