/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.servicecatalog.api.model;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.servicecatalog.api.model.ServiceInstance;
import io.ap4k.deps.servicecatalog.api.model.ServiceInstanceFluent;
import io.ap4k.deps.servicecatalog.api.model.ServiceInstanceFluentImpl;

public class ServiceInstanceBuilder
extends ServiceInstanceFluentImpl<ServiceInstanceBuilder>
implements VisitableBuilder<ServiceInstance, ServiceInstanceBuilder> {
    ServiceInstanceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServiceInstanceBuilder() {
        this(true);
    }

    public ServiceInstanceBuilder(Boolean validationEnabled) {
        this(new ServiceInstance(), validationEnabled);
    }

    public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceInstance(), validationEnabled);
    }

    public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent, ServiceInstance instance) {
        this(fluent, instance, true);
    }

    public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent, ServiceInstance instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServiceInstanceBuilder(ServiceInstance instance) {
        this(instance, (Boolean)true);
    }

    public ServiceInstanceBuilder(ServiceInstance instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServiceInstanceBuilder(Validator validator) {
        this(new ServiceInstance(), (Boolean)true);
    }

    public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent, ServiceInstance instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ServiceInstanceBuilder(ServiceInstance instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ServiceInstance build() {
        ServiceInstance buildable = new ServiceInstance(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceInstanceBuilder that = (ServiceInstanceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

