/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.zjsonpatch;

import io.ap4k.deps.jackson.databind.JsonNode;
import io.ap4k.deps.jackson.databind.node.ArrayNode;
import io.ap4k.deps.jackson.databind.node.ObjectNode;
import io.ap4k.deps.zjsonpatch.Constants;
import io.ap4k.deps.zjsonpatch.Operation;
import io.ap4k.deps.zjsonpatch.internal.guava.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class JsonPatch {
    private JsonPatch() {
    }

    public static JsonNode apply(JsonNode patch, JsonNode source) {
        Iterator<JsonNode> operations = patch.iterator();
        Object ret = source.deepCopy();
        while (operations.hasNext()) {
            JsonNode jsonNode = operations.next();
            Operation operation = Operation.fromRfcName(jsonNode.get(Constants.OP).toString().replaceAll("\"", ""));
            List<String> path = JsonPatch.getPath(jsonNode.get(Constants.PATH));
            List<String> fromPath = null;
            if (Operation.MOVE.equals((Object)operation)) {
                fromPath = JsonPatch.getPath(jsonNode.get(Constants.FROM));
            }
            JsonNode value = null;
            if (!Operation.REMOVE.equals((Object)operation) && !Operation.MOVE.equals((Object)operation)) {
                value = jsonNode.get(Constants.VALUE);
            }
            switch (operation) {
                case REMOVE: {
                    JsonPatch.remove(ret, path);
                    break;
                }
                case REPLACE: {
                    ret = JsonPatch.replace(ret, path, value);
                    break;
                }
                case ADD: {
                    ret = JsonPatch.add(ret, path, value);
                    break;
                }
                case MOVE: {
                    ret = JsonPatch.move(ret, fromPath, path);
                }
            }
        }
        return ret;
    }

    private static JsonNode move(JsonNode node, List<String> fromPath, List<String> toPath) {
        JsonNode parentNode = JsonPatch.getParentNode(node, fromPath);
        String field = fromPath.get(fromPath.size() - 1).replaceAll("\"", "");
        JsonNode valueNode = parentNode.isArray() ? parentNode.get(Integer.parseInt(field)) : parentNode.get(field);
        JsonPatch.remove(node, fromPath);
        return JsonPatch.add(node, toPath, valueNode);
    }

    private static JsonNode add(JsonNode node, List<String> path, JsonNode value) {
        if (path.isEmpty()) {
            throw new RuntimeException("[ADD Operation] path is empty , path : ");
        }
        JsonNode parentNode = JsonPatch.getParentNode(node, path);
        if (parentNode == null) {
            throw new RuntimeException("[ADD Operation] noSuchPath in source, path provided : " + path);
        }
        String fieldToReplace = path.get(path.size() - 1).replaceAll("\"", "");
        if (fieldToReplace.equals("") && path.size() == 1) {
            return value;
        }
        if (!parentNode.isContainerNode()) {
            throw new RuntimeException("[ADD Operation] parent is not a container in source, path provided : " + path + " | node : " + parentNode);
        }
        if (parentNode.isArray()) {
            JsonPatch.addToArray(path, value, parentNode);
        } else {
            JsonPatch.addToObject(path, parentNode, value);
        }
        return node;
    }

    private static void addToObject(List<String> path, JsonNode node, JsonNode value) {
        ObjectNode target = (ObjectNode)node;
        String key = path.get(path.size() - 1).replaceAll("\"", "");
        target.put(key, value);
    }

    private static void addToArray(List<String> path, JsonNode value, JsonNode parentNode) {
        ArrayNode target = (ArrayNode)parentNode;
        String idxStr = path.get(path.size() - 1);
        if ("-".equals(idxStr)) {
            target.add(value);
        } else {
            Integer idx = Integer.parseInt(idxStr.replaceAll("\"", ""));
            if (idx < target.size()) {
                target.insert((int)idx, value);
            } else if (idx.intValue() == target.size()) {
                target.add(value);
            } else {
                throw new RuntimeException("[ADD Operation] [addToArray] index Out of bound, index provided is higher than allowed, path " + path);
            }
        }
    }

    private static JsonNode replace(JsonNode node, List<String> path, JsonNode value) {
        if (path.isEmpty()) {
            throw new RuntimeException("[Replace Operation] path is empty");
        }
        JsonNode parentNode = JsonPatch.getParentNode(node, path);
        if (parentNode == null) {
            throw new RuntimeException("[Replace Operation] noSuchPath in source, path provided : " + path);
        }
        String fieldToReplace = path.get(path.size() - 1).replaceAll("\"", "");
        if (Strings.isNullOrEmpty(fieldToReplace) && path.size() == 1) {
            return value;
        }
        if (parentNode.isObject()) {
            ((ObjectNode)parentNode).put(fieldToReplace, value);
        } else {
            ((ArrayNode)parentNode).set(Integer.parseInt(fieldToReplace), value);
        }
        return node;
    }

    private static void remove(JsonNode node, List<String> path) {
        if (path.isEmpty()) {
            throw new RuntimeException("[Remove Operation] path is empty");
        }
        JsonNode parentNode = JsonPatch.getParentNode(node, path);
        if (parentNode == null) {
            throw new RuntimeException("[Remove Operation] noSuchPath in source, path provided : " + path);
        }
        String fieldToRemove = path.get(path.size() - 1).replaceAll("\"", "");
        if (parentNode.isObject()) {
            ((ObjectNode)parentNode).remove(fieldToRemove);
        } else {
            ((ArrayNode)parentNode).remove(Integer.parseInt(fieldToRemove));
        }
    }

    private static JsonNode getParentNode(JsonNode node, List<String> fromPath) {
        List<String> pathToParent = fromPath.subList(0, fromPath.size() - 1);
        return JsonPatch.getNode(node, pathToParent, 1);
    }

    private static JsonNode getNode(JsonNode ret, List<String> path, int pos) {
        if (pos >= path.size()) {
            return ret;
        }
        String key = path.get(pos);
        if (ret.isArray()) {
            int keyInt = Integer.parseInt(key.replaceAll("\"", ""));
            return JsonPatch.getNode(ret.get(keyInt), path, ++pos);
        }
        if (ret.isObject()) {
            if (ret.has(key)) {
                return JsonPatch.getNode(ret.get(key), path, ++pos);
            }
            return null;
        }
        return ret;
    }

    private static List<String> getPath(JsonNode path) {
        String pathString = path.toString().replaceAll("\"", "");
        String[] paths = pathString.split("/");
        if (paths.length == 0) {
            return Arrays.asList("", "");
        }
        ArrayList<String> pathList = new ArrayList<String>();
        for (String p : paths) {
            pathList.add(p.replaceAll("~1", "/").replaceAll("~0", "~"));
        }
        if (pathString.endsWith("/")) {
            pathList.add("");
        }
        return Collections.unmodifiableList(pathList);
    }
}

