/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.applicationcrd.api.client;

import io.ap4k.deps.applicationcrd.api.client.ApplicationClient;
import io.ap4k.deps.applicationcrd.api.client.DefaultApplicationClient;
import io.ap4k.deps.kubernetes.api.model.RootPaths;
import io.ap4k.deps.kubernetes.client.Client;
import io.ap4k.deps.kubernetes.client.Config;
import io.ap4k.deps.kubernetes.client.ExtensionAdapter;
import io.ap4k.deps.okhttp3.OkHttpClient;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ApplicationExtensionAdapter
implements ExtensionAdapter<ApplicationClient> {
    static final ConcurrentMap<URL, Boolean> IS_SERVICE_CATALOG = new ConcurrentHashMap<URL, Boolean>();
    static final ConcurrentMap<URL, Boolean> USES_SERVICE_CATALOG_APIGROUPS = new ConcurrentHashMap<URL, Boolean>();

    @Override
    public Class<ApplicationClient> getExtensionType() {
        return ApplicationClient.class;
    }

    @Override
    public Boolean isAdaptable(Client client) {
        return this.isServiceCatalogAvailable(client);
    }

    @Override
    public ApplicationClient adapt(Client client) {
        return new DefaultApplicationClient(client.adapt(OkHttpClient.class), (Config)client.getConfiguration());
    }

    private boolean isServiceCatalogAvailable(Client client) {
        List<String> paths;
        URL masterUrl = client.getMasterUrl();
        if (IS_SERVICE_CATALOG.containsKey(masterUrl)) {
            return (Boolean)IS_SERVICE_CATALOG.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.endsWith("servicecatalog.k8s.io") && !path.contains("servicecatalog.k8s.io/")) continue;
                USES_SERVICE_CATALOG_APIGROUPS.putIfAbsent(masterUrl, true);
                IS_SERVICE_CATALOG.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        IS_SERVICE_CATALOG.putIfAbsent(masterUrl, false);
        return false;
    }
}

