/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.applicationcrd.api.model;

import io.ap4k.deps.applicationcrd.api.model.Application;
import io.ap4k.deps.applicationcrd.api.model.ApplicationBuilder;
import io.ap4k.deps.applicationcrd.api.model.ApplicationFluentImpl;
import io.ap4k.deps.applicationcrd.api.model.ApplicationList;
import io.ap4k.deps.applicationcrd.api.model.ApplicationListFluent;
import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ApplicationListFluentImpl<A extends ApplicationListFluent<A>>
extends BaseFluent<A>
implements ApplicationListFluent<A> {
    private String apiVersion;
    private List<ApplicationBuilder> items;
    private String kind;
    private ListMeta metadata;

    public ApplicationListFluentImpl() {
    }

    public ApplicationListFluentImpl(ApplicationList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, Application item) {
        if (this.items == null) {
            this.items = new ArrayList<ApplicationBuilder>();
        }
        ApplicationBuilder builder = new ApplicationBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, Application item) {
        if (this.items == null) {
            this.items = new ArrayList<ApplicationBuilder>();
        }
        ApplicationBuilder builder = new ApplicationBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Application ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ApplicationBuilder>();
        }
        for (Application item : items) {
            ApplicationBuilder builder = new ApplicationBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Application> items) {
        if (this.items == null) {
            this.items = new ArrayList<ApplicationBuilder>();
        }
        for (Application item : items) {
            ApplicationBuilder builder = new ApplicationBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Application ... items) {
        for (Application item : items) {
            ApplicationBuilder builder = new ApplicationBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Application> items) {
        for (Application item : items) {
            ApplicationBuilder builder = new ApplicationBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Application> getItems() {
        return ApplicationListFluentImpl.build(this.items);
    }

    @Override
    public List<Application> buildItems() {
        return ApplicationListFluentImpl.build(this.items);
    }

    @Override
    public Application buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public Application buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Application buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Application buildMatchingItem(Predicate<ApplicationBuilder> predicate) {
        for (ApplicationBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ApplicationBuilder> predicate) {
        for (ApplicationBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<Application> items) {
        if (this.items != null) {
            this._visitables.removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ApplicationBuilder>();
            for (Application item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = new ArrayList<ApplicationBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withItems(Application ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Application item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ApplicationListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ApplicationListFluent.ItemsNested<A> addNewItemLike(Application item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ApplicationListFluent.ItemsNested<A> setNewItemLike(int index, Application item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ApplicationListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ApplicationListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ApplicationListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ApplicationListFluent.ItemsNested<A> editMatchingItem(Predicate<ApplicationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplicationListFluentImpl that = (ApplicationListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class ItemsNestedImpl<N>
    extends ApplicationFluentImpl<ApplicationListFluent.ItemsNested<N>>
    implements ApplicationListFluent.ItemsNested<N>,
    Nested<N> {
        private final ApplicationBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, Application item) {
            this.index = index;
            this.builder = new ApplicationBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ApplicationBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApplicationListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

