/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.applicationcrd.api.model;

import io.ap4k.deps.applicationcrd.api.model.ApplicationSpec;
import io.ap4k.deps.applicationcrd.api.model.ApplicationSpecFluent;
import io.ap4k.deps.applicationcrd.api.model.ApplicationSpecFluentImpl;
import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;

public class ApplicationSpecBuilder
extends ApplicationSpecFluentImpl<ApplicationSpecBuilder>
implements VisitableBuilder<ApplicationSpec, ApplicationSpecBuilder> {
    ApplicationSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ApplicationSpecBuilder() {
        this(true);
    }

    public ApplicationSpecBuilder(Boolean validationEnabled) {
        this(new ApplicationSpec(), validationEnabled);
    }

    public ApplicationSpecBuilder(ApplicationSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ApplicationSpecBuilder(ApplicationSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ApplicationSpec(), validationEnabled);
    }

    public ApplicationSpecBuilder(ApplicationSpecFluent<?> fluent, ApplicationSpec instance) {
        this(fluent, instance, true);
    }

    public ApplicationSpecBuilder(ApplicationSpecFluent<?> fluent, ApplicationSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAssemblyPhase(instance.getAssemblyPhase());
        fluent.withComponentKinds(instance.getComponentKinds());
        fluent.withDescriptor(instance.getDescriptor());
        fluent.withInfo(instance.getInfo());
        fluent.withSelector(instance.getSelector());
        this.validationEnabled = validationEnabled;
    }

    public ApplicationSpecBuilder(ApplicationSpec instance) {
        this(instance, (Boolean)true);
    }

    public ApplicationSpecBuilder(ApplicationSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAssemblyPhase(instance.getAssemblyPhase());
        this.withComponentKinds(instance.getComponentKinds());
        this.withDescriptor(instance.getDescriptor());
        this.withInfo(instance.getInfo());
        this.withSelector(instance.getSelector());
        this.validationEnabled = validationEnabled;
    }

    public ApplicationSpecBuilder(Validator validator) {
        this(new ApplicationSpec(), (Boolean)true);
    }

    public ApplicationSpecBuilder(ApplicationSpecFluent<?> fluent, ApplicationSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAssemblyPhase(instance.getAssemblyPhase());
        fluent.withComponentKinds(instance.getComponentKinds());
        fluent.withDescriptor(instance.getDescriptor());
        fluent.withInfo(instance.getInfo());
        fluent.withSelector(instance.getSelector());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ApplicationSpecBuilder(ApplicationSpec instance, Validator validator) {
        this.fluent = this;
        this.withAssemblyPhase(instance.getAssemblyPhase());
        this.withComponentKinds(instance.getComponentKinds());
        this.withDescriptor(instance.getDescriptor());
        this.withInfo(instance.getInfo());
        this.withSelector(instance.getSelector());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ApplicationSpec build() {
        ApplicationSpec buildable = new ApplicationSpec(this.fluent.getAssemblyPhase(), this.fluent.getComponentKinds(), this.fluent.getDescriptor(), this.fluent.getInfo(), this.fluent.getSelector());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplicationSpecBuilder that = (ApplicationSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

