/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.applicationcrd.api.model;

import io.ap4k.deps.applicationcrd.api.model.ImageSpec;
import io.ap4k.deps.applicationcrd.api.model.ImageSpecFluent;
import io.ap4k.deps.applicationcrd.api.model.ImageSpecFluentImpl;
import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;

public class ImageSpecBuilder
extends ImageSpecFluentImpl<ImageSpecBuilder>
implements VisitableBuilder<ImageSpec, ImageSpecBuilder> {
    ImageSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ImageSpecBuilder() {
        this(true);
    }

    public ImageSpecBuilder(Boolean validationEnabled) {
        this(new ImageSpec(), validationEnabled);
    }

    public ImageSpecBuilder(ImageSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageSpecBuilder(ImageSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageSpec(), validationEnabled);
    }

    public ImageSpecBuilder(ImageSpecFluent<?> fluent, ImageSpec instance) {
        this(fluent, instance, true);
    }

    public ImageSpecBuilder(ImageSpecFluent<?> fluent, ImageSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withSize(instance.getSize());
        fluent.withSrc(instance.getSrc());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public ImageSpecBuilder(ImageSpec instance) {
        this(instance, (Boolean)true);
    }

    public ImageSpecBuilder(ImageSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withSize(instance.getSize());
        this.withSrc(instance.getSrc());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public ImageSpecBuilder(Validator validator) {
        this(new ImageSpec(), (Boolean)true);
    }

    public ImageSpecBuilder(ImageSpecFluent<?> fluent, ImageSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withSize(instance.getSize());
        fluent.withSrc(instance.getSrc());
        fluent.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ImageSpecBuilder(ImageSpec instance, Validator validator) {
        this.fluent = this;
        this.withSize(instance.getSize());
        this.withSrc(instance.getSrc());
        this.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ImageSpec build() {
        ImageSpec buildable = new ImageSpec(this.fluent.getSize(), this.fluent.getSrc(), this.fluent.getType());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSpecBuilder that = (ImageSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

