/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.applicationcrd.api.model;

import io.ap4k.deps.applicationcrd.api.model.ValidationSchema;
import io.ap4k.deps.applicationcrd.api.model.ValidationSchemaFluent;
import io.ap4k.deps.applicationcrd.api.model.ValidationSchemaFluentImpl;
import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;

public class ValidationSchemaBuilder
extends ValidationSchemaFluentImpl<ValidationSchemaBuilder>
implements VisitableBuilder<ValidationSchema, ValidationSchemaBuilder> {
    ValidationSchemaFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ValidationSchemaBuilder() {
        this(true);
    }

    public ValidationSchemaBuilder(Boolean validationEnabled) {
        this(new ValidationSchema(), validationEnabled);
    }

    public ValidationSchemaBuilder(ValidationSchemaFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ValidationSchemaBuilder(ValidationSchemaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ValidationSchema(), validationEnabled);
    }

    public ValidationSchemaBuilder(ValidationSchemaFluent<?> fluent, ValidationSchema instance) {
        this(fluent, instance, true);
    }

    public ValidationSchemaBuilder(ValidationSchemaFluent<?> fluent, ValidationSchema instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApplication(instance.getApplication());
        fluent.withApplicationList(instance.getApplicationList());
        this.validationEnabled = validationEnabled;
    }

    public ValidationSchemaBuilder(ValidationSchema instance) {
        this(instance, (Boolean)true);
    }

    public ValidationSchemaBuilder(ValidationSchema instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApplication(instance.getApplication());
        this.withApplicationList(instance.getApplicationList());
        this.validationEnabled = validationEnabled;
    }

    public ValidationSchemaBuilder(Validator validator) {
        this(new ValidationSchema(), (Boolean)true);
    }

    public ValidationSchemaBuilder(ValidationSchemaFluent<?> fluent, ValidationSchema instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApplication(instance.getApplication());
        fluent.withApplicationList(instance.getApplicationList());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ValidationSchemaBuilder(ValidationSchema instance, Validator validator) {
        this.fluent = this;
        this.withApplication(instance.getApplication());
        this.withApplicationList(instance.getApplicationList());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ValidationSchema build() {
        ValidationSchema buildable = new ValidationSchema(this.fluent.getApplication(), this.fluent.getApplicationList());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValidationSchemaBuilder that = (ValidationSchemaBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

