/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.jackson.databind.deser.impl;

import io.ap4k.deps.jackson.databind.BeanDescription;
import io.ap4k.deps.jackson.databind.DeserializationConfig;
import io.ap4k.deps.jackson.databind.DeserializationContext;
import io.ap4k.deps.jackson.databind.JavaType;
import io.ap4k.deps.jackson.databind.MapperFeature;
import io.ap4k.deps.jackson.databind.cfg.MapperConfig;
import io.ap4k.deps.jackson.databind.deser.CreatorProperty;
import io.ap4k.deps.jackson.databind.deser.SettableBeanProperty;
import io.ap4k.deps.jackson.databind.deser.ValueInstantiator;
import io.ap4k.deps.jackson.databind.deser.std.StdValueInstantiator;
import io.ap4k.deps.jackson.databind.introspect.AnnotatedMember;
import io.ap4k.deps.jackson.databind.introspect.AnnotatedParameter;
import io.ap4k.deps.jackson.databind.introspect.AnnotatedWithParams;
import io.ap4k.deps.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CreatorCollector {
    protected static final int C_DEFAULT = 0;
    protected static final int C_STRING = 1;
    protected static final int C_INT = 2;
    protected static final int C_LONG = 3;
    protected static final int C_DOUBLE = 4;
    protected static final int C_BOOLEAN = 5;
    protected static final int C_DELEGATE = 6;
    protected static final int C_PROPS = 7;
    protected static final int C_ARRAY_DELEGATE = 8;
    protected static final String[] TYPE_DESCS = new String[]{"default", "String", "int", "long", "double", "boolean", "delegate", "property-based"};
    protected final BeanDescription _beanDesc;
    protected final boolean _canFixAccess;
    protected final boolean _forceAccess;
    protected final AnnotatedWithParams[] _creators = new AnnotatedWithParams[9];
    protected int _explicitCreators = 0;
    protected boolean _hasNonDefaultCreator = false;
    protected SettableBeanProperty[] _delegateArgs;
    protected SettableBeanProperty[] _arrayDelegateArgs;
    protected SettableBeanProperty[] _propertyBasedArgs;
    protected AnnotatedParameter _incompleteParameter;

    public CreatorCollector(BeanDescription beanDesc, MapperConfig<?> config) {
        this._beanDesc = beanDesc;
        this._canFixAccess = config.canOverrideAccessModifiers();
        this._forceAccess = config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS);
    }

    public ValueInstantiator constructValueInstantiator(DeserializationConfig config) {
        JavaType delegateType = this._computeDelegateType(this._creators[6], this._delegateArgs);
        JavaType arrayDelegateType = this._computeDelegateType(this._creators[8], this._arrayDelegateArgs);
        JavaType type = this._beanDesc.getType();
        if (!this._hasNonDefaultCreator) {
            Class<?> rawType = type.getRawClass();
            if (rawType == Collection.class || rawType == List.class || rawType == ArrayList.class) {
                return new Vanilla(1);
            }
            if (rawType == Map.class || rawType == LinkedHashMap.class) {
                return new Vanilla(2);
            }
            if (rawType == HashMap.class) {
                return new Vanilla(3);
            }
        }
        StdValueInstantiator inst = new StdValueInstantiator(config, type);
        inst.configureFromObjectSettings(this._creators[0], this._creators[6], delegateType, this._delegateArgs, this._creators[7], this._propertyBasedArgs);
        inst.configureFromArraySettings(this._creators[8], arrayDelegateType, this._arrayDelegateArgs);
        inst.configureFromStringCreator(this._creators[1]);
        inst.configureFromIntCreator(this._creators[2]);
        inst.configureFromLongCreator(this._creators[3]);
        inst.configureFromDoubleCreator(this._creators[4]);
        inst.configureFromBooleanCreator(this._creators[5]);
        inst.configureIncompleteParameter(this._incompleteParameter);
        return inst;
    }

    public void setDefaultCreator(AnnotatedWithParams creator) {
        this._creators[0] = this._fixAccess(creator);
    }

    public void addStringCreator(AnnotatedWithParams creator, boolean explicit) {
        this.verifyNonDup(creator, 1, explicit);
    }

    public void addIntCreator(AnnotatedWithParams creator, boolean explicit) {
        this.verifyNonDup(creator, 2, explicit);
    }

    public void addLongCreator(AnnotatedWithParams creator, boolean explicit) {
        this.verifyNonDup(creator, 3, explicit);
    }

    public void addDoubleCreator(AnnotatedWithParams creator, boolean explicit) {
        this.verifyNonDup(creator, 4, explicit);
    }

    public void addBooleanCreator(AnnotatedWithParams creator, boolean explicit) {
        this.verifyNonDup(creator, 5, explicit);
    }

    public void addDelegatingCreator(AnnotatedWithParams creator, boolean explicit, SettableBeanProperty[] injectables) {
        if (creator.getParameterType(0).isCollectionLikeType()) {
            this.verifyNonDup(creator, 8, explicit);
            this._arrayDelegateArgs = injectables;
        } else {
            this.verifyNonDup(creator, 6, explicit);
            this._delegateArgs = injectables;
        }
    }

    public void addPropertyCreator(AnnotatedWithParams creator, boolean explicit, SettableBeanProperty[] properties) {
        this.verifyNonDup(creator, 7, explicit);
        if (properties.length > 1) {
            HashMap<String, Integer> names = new HashMap<String, Integer>();
            int len = properties.length;
            for (int i = 0; i < len; ++i) {
                Integer old;
                String name = properties[i].getName();
                if (name.length() == 0 && properties[i].getInjectableValueId() != null || (old = names.put(name, i)) == null) continue;
                throw new IllegalArgumentException("Duplicate creator property \"" + name + "\" (index " + old + " vs " + i + ")");
            }
        }
        this._propertyBasedArgs = properties;
    }

    public void addIncompeteParameter(AnnotatedParameter parameter) {
        if (this._incompleteParameter == null) {
            this._incompleteParameter = parameter;
        }
    }

    @Deprecated
    public void addStringCreator(AnnotatedWithParams creator) {
        this.addStringCreator(creator, false);
    }

    @Deprecated
    public void addIntCreator(AnnotatedWithParams creator) {
        this.addBooleanCreator(creator, false);
    }

    @Deprecated
    public void addLongCreator(AnnotatedWithParams creator) {
        this.addBooleanCreator(creator, false);
    }

    @Deprecated
    public void addDoubleCreator(AnnotatedWithParams creator) {
        this.addBooleanCreator(creator, false);
    }

    @Deprecated
    public void addBooleanCreator(AnnotatedWithParams creator) {
        this.addBooleanCreator(creator, false);
    }

    @Deprecated
    public void addDelegatingCreator(AnnotatedWithParams creator, CreatorProperty[] injectables) {
        this.addDelegatingCreator(creator, false, injectables);
    }

    @Deprecated
    public void addPropertyCreator(AnnotatedWithParams creator, CreatorProperty[] properties) {
        this.addPropertyCreator(creator, false, properties);
    }

    public boolean hasDefaultCreator() {
        return this._creators[0] != null;
    }

    public boolean hasDelegatingCreator() {
        return this._creators[6] != null;
    }

    public boolean hasPropertyBasedCreator() {
        return this._creators[7] != null;
    }

    private JavaType _computeDelegateType(AnnotatedWithParams creator, SettableBeanProperty[] delegateArgs) {
        if (!this._hasNonDefaultCreator || creator == null) {
            return null;
        }
        int ix = 0;
        if (delegateArgs != null) {
            int len = delegateArgs.length;
            for (int i = 0; i < len; ++i) {
                if (delegateArgs[i] != null) continue;
                ix = i;
                break;
            }
        }
        return creator.getParameterType(ix);
    }

    private <T extends AnnotatedMember> T _fixAccess(T member) {
        if (member != null && this._canFixAccess) {
            ClassUtil.checkAndFixAccess((Member)((Object)member.getAnnotated()), this._forceAccess);
        }
        return member;
    }

    protected void verifyNonDup(AnnotatedWithParams newOne, int typeIndex, boolean explicit) {
        int mask = 1 << typeIndex;
        this._hasNonDefaultCreator = true;
        AnnotatedWithParams oldOne = this._creators[typeIndex];
        if (oldOne != null) {
            boolean verify;
            if ((this._explicitCreators & mask) != 0) {
                if (!explicit) {
                    return;
                }
                verify = true;
            } else {
                boolean bl = verify = !explicit;
            }
            if (verify && oldOne.getClass() == newOne.getClass()) {
                Class<?> newType;
                Class<?> oldType = oldOne.getRawParameterType(0);
                if (oldType == (newType = newOne.getRawParameterType(0))) {
                    throw new IllegalArgumentException("Conflicting " + TYPE_DESCS[typeIndex] + " creators: already had explicitly marked " + oldOne + ", encountered " + newOne);
                }
                if (newType.isAssignableFrom(oldType)) {
                    return;
                }
            }
        }
        if (explicit) {
            this._explicitCreators |= mask;
        }
        this._creators[typeIndex] = this._fixAccess(newOne);
    }

    protected static final class Vanilla
    extends ValueInstantiator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final int TYPE_COLLECTION = 1;
        public static final int TYPE_MAP = 2;
        public static final int TYPE_HASH_MAP = 3;
        private final int _type;

        public Vanilla(int t) {
            this._type = t;
        }

        @Override
        public String getValueTypeDesc() {
            switch (this._type) {
                case 1: {
                    return ArrayList.class.getName();
                }
                case 2: {
                    return LinkedHashMap.class.getName();
                }
                case 3: {
                    return HashMap.class.getName();
                }
            }
            return Object.class.getName();
        }

        @Override
        public boolean canInstantiate() {
            return true;
        }

        @Override
        public boolean canCreateUsingDefault() {
            return true;
        }

        @Override
        public Object createUsingDefault(DeserializationContext ctxt) throws IOException {
            switch (this._type) {
                case 1: {
                    return new ArrayList();
                }
                case 2: {
                    return new LinkedHashMap();
                }
                case 3: {
                    return new HashMap();
                }
            }
            throw new IllegalStateException("Unknown type " + this._type);
        }
    }
}

