/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.jackson.databind.ext;

import io.ap4k.deps.jackson.core.JsonParser;
import io.ap4k.deps.jackson.core.JsonProcessingException;
import io.ap4k.deps.jackson.databind.BeanDescription;
import io.ap4k.deps.jackson.databind.DeserializationConfig;
import io.ap4k.deps.jackson.databind.DeserializationContext;
import io.ap4k.deps.jackson.databind.JavaType;
import io.ap4k.deps.jackson.databind.JsonDeserializer;
import io.ap4k.deps.jackson.databind.deser.Deserializers;
import io.ap4k.deps.jackson.databind.deser.std.FromStringDeserializer;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class CoreXMLDeserializers
extends Deserializers.Base {
    static final DatatypeFactory _dataTypeFactory;
    protected static final int TYPE_DURATION = 1;
    protected static final int TYPE_G_CALENDAR = 2;
    protected static final int TYPE_QNAME = 3;

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) {
        Class<?> raw = type.getRawClass();
        if (raw == QName.class) {
            return new Std(raw, 3);
        }
        if (raw == XMLGregorianCalendar.class) {
            return new Std(raw, 2);
        }
        if (raw == Duration.class) {
            return new Std(raw, 1);
        }
        return null;
    }

    static {
        try {
            _dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Std
    extends FromStringDeserializer<Object> {
        private static final long serialVersionUID = 1L;
        protected final int _kind;

        public Std(Class<?> raw, int kind) {
            super(raw);
            this._kind = kind;
        }

        @Override
        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (this._kind == 2) {
                Date d = this._parseDate(jp, ctxt);
                if (d == null) {
                    return null;
                }
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(d);
                TimeZone tz = ctxt.getTimeZone();
                if (tz != null) {
                    calendar.setTimeZone(tz);
                }
                return _dataTypeFactory.newXMLGregorianCalendar(calendar);
            }
            return super.deserialize(jp, ctxt);
        }

        @Override
        protected Object _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            switch (this._kind) {
                case 1: {
                    return _dataTypeFactory.newDuration(value);
                }
                case 3: {
                    return QName.valueOf(value);
                }
            }
            throw new IllegalStateException();
        }
    }
}

