/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.jackson.databind.introspect;

import io.ap4k.deps.jackson.annotation.JsonFormat;
import io.ap4k.deps.jackson.annotation.JsonInclude;
import io.ap4k.deps.jackson.databind.AnnotationIntrospector;
import io.ap4k.deps.jackson.databind.BeanProperty;
import io.ap4k.deps.jackson.databind.PropertyMetadata;
import io.ap4k.deps.jackson.databind.cfg.MapperConfig;
import io.ap4k.deps.jackson.databind.introspect.AnnotatedMember;
import java.io.Serializable;

public abstract class ConcreteBeanPropertyBase
implements BeanProperty,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final PropertyMetadata _metadata;
    protected transient JsonFormat.Value _format;

    protected ConcreteBeanPropertyBase(PropertyMetadata md) {
        this._metadata = md == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : md;
    }

    protected ConcreteBeanPropertyBase(ConcreteBeanPropertyBase src) {
        this._metadata = src._metadata;
        this._format = src._format;
    }

    @Override
    public boolean isRequired() {
        return this._metadata.isRequired();
    }

    @Override
    public PropertyMetadata getMetadata() {
        return this._metadata;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    @Deprecated
    public final JsonFormat.Value findFormatOverrides(AnnotationIntrospector intr) {
        JsonFormat.Value f = this._format;
        if (f == null) {
            AnnotatedMember member;
            if (intr != null && (member = this.getMember()) != null) {
                f = intr.findFormat(member);
            }
            if (f == null) {
                f = EMPTY_FORMAT;
            }
        }
        return f;
    }

    @Override
    public JsonFormat.Value findPropertyFormat(MapperConfig<?> config, Class<?> baseType) {
        JsonFormat.Value v0 = config.getDefaultPropertyFormat(baseType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        AnnotatedMember member = this.getMember();
        if (intr == null || member == null) {
            return v0;
        }
        JsonFormat.Value v = intr.findFormat(member);
        if (v == null) {
            return v0;
        }
        return v0.withOverrides(v);
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(MapperConfig<?> config, Class<?> baseType) {
        JsonInclude.Value v0 = config.getDefaultPropertyInclusion(baseType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        AnnotatedMember member = this.getMember();
        if (intr == null || member == null) {
            return v0;
        }
        JsonInclude.Value v = intr.findPropertyInclusion(member);
        if (v == null) {
            return v0;
        }
        return v0.withOverrides(v);
    }
}

