/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.jackson.databind.ser.std;

import io.ap4k.deps.jackson.core.JsonGenerator;
import io.ap4k.deps.jackson.databind.BeanProperty;
import io.ap4k.deps.jackson.databind.JavaType;
import io.ap4k.deps.jackson.databind.JsonMappingException;
import io.ap4k.deps.jackson.databind.JsonSerializer;
import io.ap4k.deps.jackson.databind.PropertyMetadata;
import io.ap4k.deps.jackson.databind.PropertyName;
import io.ap4k.deps.jackson.databind.SerializerProvider;
import io.ap4k.deps.jackson.databind.introspect.AnnotatedMember;
import io.ap4k.deps.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import io.ap4k.deps.jackson.databind.jsontype.TypeSerializer;
import io.ap4k.deps.jackson.databind.node.ObjectNode;
import io.ap4k.deps.jackson.databind.ser.PropertyWriter;
import io.ap4k.deps.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.annotation.Annotation;

public class MapProperty
extends PropertyWriter {
    private static final long serialVersionUID = 1L;
    protected final TypeSerializer _typeSerializer;
    protected final BeanProperty _property;
    protected Object _key;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;

    public MapProperty(TypeSerializer typeSer, BeanProperty prop) {
        super(prop == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : prop.getMetadata());
        this._typeSerializer = typeSer;
        this._property = prop;
    }

    public void reset(Object key, JsonSerializer<Object> keySer, JsonSerializer<Object> valueSer) {
        this._key = key;
        this._keySerializer = keySer;
        this._valueSerializer = valueSer;
    }

    @Override
    public String getName() {
        if (this._key instanceof String) {
            return (String)this._key;
        }
        return String.valueOf(this._key);
    }

    @Override
    public PropertyName getFullName() {
        return new PropertyName(this.getName());
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._property == null ? null : (A)this._property.getAnnotation(acls);
    }

    @Override
    public <A extends Annotation> A getContextAnnotation(Class<A> acls) {
        return this._property == null ? null : (A)this._property.getContextAnnotation(acls);
    }

    @Override
    public void serializeAsField(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this._keySerializer.serialize(this._key, gen, provider);
        if (this._typeSerializer == null) {
            this._valueSerializer.serialize(value, gen, provider);
        } else {
            this._valueSerializer.serializeWithType(value, gen, provider, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsOmittedField(Object value, JsonGenerator gen, SerializerProvider provider) throws Exception {
        if (!gen.canOmitFields()) {
            gen.writeOmittedField(this.getName());
        }
    }

    @Override
    public void serializeAsElement(Object value, JsonGenerator gen, SerializerProvider provider) throws Exception {
        if (this._typeSerializer == null) {
            this._valueSerializer.serialize(value, gen, provider);
        } else {
            this._valueSerializer.serializeWithType(value, gen, provider, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsPlaceholder(Object value, JsonGenerator gen, SerializerProvider provider) throws Exception {
        gen.writeNull();
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor objectVisitor, SerializerProvider provider) throws JsonMappingException {
        if (this._property != null) {
            this._property.depositSchemaProperty(objectVisitor, provider);
        }
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(ObjectNode propertiesNode, SerializerProvider provider) throws JsonMappingException {
    }

    @Override
    public JavaType getType() {
        return this._property == null ? TypeFactory.unknownType() : this._property.getType();
    }

    @Override
    public PropertyName getWrapperName() {
        return this._property == null ? null : this._property.getWrapperName();
    }

    @Override
    public AnnotatedMember getMember() {
        return this._property == null ? null : this._property.getMember();
    }
}

