/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.jackson.databind.ser.std;

import io.ap4k.deps.jackson.core.JsonGenerator;
import io.ap4k.deps.jackson.databind.JavaType;
import io.ap4k.deps.jackson.databind.JsonMappingException;
import io.ap4k.deps.jackson.databind.JsonNode;
import io.ap4k.deps.jackson.databind.SerializerProvider;
import io.ap4k.deps.jackson.databind.annotation.JacksonStdImpl;
import io.ap4k.deps.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.ap4k.deps.jackson.databind.jsontype.TypeSerializer;
import io.ap4k.deps.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class NullSerializer
extends StdSerializer<Object> {
    public static final NullSerializer instance = new NullSerializer();

    private NullSerializer() {
        super(Object.class);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeNull();
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        gen.writeNull();
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("null");
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectNullFormat(typeHint);
    }
}

