/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.jackson.dataformat.javaprop;

import io.ap4k.deps.jackson.core.FormatSchema;
import io.ap4k.deps.jackson.core.JsonEncoding;
import io.ap4k.deps.jackson.core.JsonFactory;
import io.ap4k.deps.jackson.core.JsonGenerator;
import io.ap4k.deps.jackson.core.JsonParser;
import io.ap4k.deps.jackson.core.ObjectCodec;
import io.ap4k.deps.jackson.core.Version;
import io.ap4k.deps.jackson.core.format.InputAccessor;
import io.ap4k.deps.jackson.core.format.MatchStrength;
import io.ap4k.deps.jackson.core.io.IOContext;
import io.ap4k.deps.jackson.dataformat.javaprop.JavaPropsGenerator;
import io.ap4k.deps.jackson.dataformat.javaprop.JavaPropsParser;
import io.ap4k.deps.jackson.dataformat.javaprop.JavaPropsSchema;
import io.ap4k.deps.jackson.dataformat.javaprop.PackageVersion;
import io.ap4k.deps.jackson.dataformat.javaprop.impl.PropertiesBackedGenerator;
import io.ap4k.deps.jackson.dataformat.javaprop.impl.WriterBackedGenerator;
import io.ap4k.deps.jackson.dataformat.javaprop.io.Latin1Reader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;

public class JavaPropsFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_JAVA_PROPERTIES = "java_properties";
    protected static final String CHARSET_ID_LATIN1 = "ISO-8859-1";

    public JavaPropsFactory() {
    }

    public JavaPropsFactory(ObjectCodec codec) {
        super(codec);
    }

    protected JavaPropsFactory(JavaPropsFactory src, ObjectCodec oc) {
        super(src, oc);
    }

    @Override
    public JavaPropsFactory copy() {
        this._checkInvalidCopy(JavaPropsFactory.class);
        return new JavaPropsFactory(this, null);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_JAVA_PROPERTIES;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        return MatchStrength.INCONCLUSIVE;
    }

    @Override
    public boolean requiresPropertyOrdering() {
        return false;
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return false;
    }

    @Override
    public boolean canUseCharArrays() {
        return false;
    }

    @Override
    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof JavaPropsSchema;
    }

    public JavaPropsParser createParser(Properties props) {
        return new JavaPropsParser(this._createContext(props, true), props, this._parserFeatures, this._objectCodec, props);
    }

    public JavaPropsGenerator createGenerator(Properties props) {
        return new PropertiesBackedGenerator(this._createContext(props, true), props, this._generatorFeatures, this._objectCodec);
    }

    @Override
    public JsonParser createParser(File f) throws IOException {
        return this._createParser(new FileInputStream(f), this._createContext(f, true));
    }

    @Override
    public JsonParser createParser(URL url) throws IOException {
        return this._createParser(this._optimizedStreamFromURL(url), this._createContext(url, true));
    }

    @Override
    public JsonParser createParser(InputStream in) throws IOException {
        return this._createParser(in, this._createContext(in, false));
    }

    @Override
    public JsonParser createParser(byte[] data) throws IOException {
        return this._createParser(data, 0, data.length, this._createContext(data, true));
    }

    @Override
    public JsonParser createParser(byte[] data, int offset, int len) throws IOException {
        return this._createParser(data, offset, len, this._createContext(data, true));
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        ctxt.setEncoding(enc);
        out = this._decorate(out, ctxt);
        return this._createJavaPropsGenerator(ctxt, this._generatorFeatures, this._objectCodec, out);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        out = this._decorate(out, ctxt);
        return this._createJavaPropsGenerator(ctxt, this._generatorFeatures, this._objectCodec, out);
    }

    @Override
    protected JsonParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        Properties props = this._loadProperties(in, ctxt);
        return new JavaPropsParser(ctxt, in, this._parserFeatures, this._objectCodec, props);
    }

    @Override
    protected JsonParser _createParser(Reader r, IOContext ctxt) throws IOException {
        Properties props = this._loadProperties(r, ctxt);
        return new JavaPropsParser(ctxt, r, this._parserFeatures, this._objectCodec, props);
    }

    @Override
    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        return this._createParser(new CharArrayReader(data, offset, len), ctxt);
    }

    @Override
    protected JsonParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        return this._createParser(new Latin1Reader(data, offset, len), ctxt);
    }

    @Override
    protected JsonGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        return new WriterBackedGenerator(ctxt, out, this._generatorFeatures, this._objectCodec);
    }

    @Override
    protected JsonGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createJavaPropsGenerator(ctxt, this._generatorFeatures, this._objectCodec, out);
    }

    @Override
    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        return new OutputStreamWriter(out, CHARSET_ID_LATIN1);
    }

    protected Properties _loadProperties(InputStream in, IOContext ctxt) throws IOException {
        return this._loadProperties(new Latin1Reader(ctxt, in), ctxt);
    }

    protected Properties _loadProperties(Reader r0, IOContext ctxt) throws IOException {
        Properties props = new Properties();
        if (ctxt.isResourceManaged()) {
            try (Reader r = r0;){
                props.load(r);
            }
        } else {
            props.load(r0);
        }
        return props;
    }

    private final JsonGenerator _createJavaPropsGenerator(IOContext ctxt, int stdFeat, ObjectCodec codec, OutputStream out) throws IOException {
        return new WriterBackedGenerator(ctxt, this._createWriter(out, null, ctxt), stdFeat, this._objectCodec);
    }
}

