/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.builder;

import io.ap4k.deps.javax.validation.ConstraintViolation;
import io.ap4k.deps.javax.validation.ConstraintViolationException;
import io.ap4k.deps.javax.validation.Validation;
import io.ap4k.deps.javax.validation.ValidationException;
import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.javax.validation.ValidatorFactory;
import java.util.Set;

public final class ValidationUtils {
    private static final Object LOCK = new Object();
    private static Validator validator;

    private static Validator createValidator() {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            return factory.getValidator();
        }
        catch (ValidationException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Validator getValidator() {
        Validator v = validator;
        if (v == null) {
            Object object = LOCK;
            synchronized (object) {
                v = validator;
                if (validator == null) {
                    validator = v = ValidationUtils.createValidator();
                }
            }
        }
        return v;
    }

    public static <T> void validate(T item) {
        ValidationUtils.validate(item, ValidationUtils.getValidator());
    }

    public static <T> void validate(T item, Validator v) {
        if (v == null) {
            v = ValidationUtils.getValidator();
        }
        if (v == null) {
            return;
        }
        Set<ConstraintViolation<T>> violations = v.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder("Constraint Validations: ");
            boolean first = true;
            for (ConstraintViolation<T> violation : violations) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                Object leafBean = violation.getLeafBean();
                sb.append(violation.getPropertyPath() + " " + violation.getMessage() + " on bean: " + leafBean);
            }
            throw new ConstraintViolationException(sb.toString(), violations);
        }
    }
}

