/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.AttachedVolume;
import io.ap4k.deps.kubernetes.api.model.AttachedVolumeFluent;
import io.ap4k.deps.kubernetes.api.model.AttachedVolumeFluentImpl;

public class AttachedVolumeBuilder
extends AttachedVolumeFluentImpl<AttachedVolumeBuilder>
implements VisitableBuilder<AttachedVolume, AttachedVolumeBuilder> {
    AttachedVolumeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AttachedVolumeBuilder() {
        this(true);
    }

    public AttachedVolumeBuilder(Boolean validationEnabled) {
        this(new AttachedVolume(), validationEnabled);
    }

    public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AttachedVolume(), validationEnabled);
    }

    public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent, AttachedVolume instance) {
        this(fluent, instance, true);
    }

    public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent, AttachedVolume instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDevicePath(instance.getDevicePath());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public AttachedVolumeBuilder(AttachedVolume instance) {
        this(instance, (Boolean)true);
    }

    public AttachedVolumeBuilder(AttachedVolume instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDevicePath(instance.getDevicePath());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public AttachedVolumeBuilder(Validator validator) {
        this(new AttachedVolume(), (Boolean)true);
    }

    public AttachedVolumeBuilder(AttachedVolumeFluent<?> fluent, AttachedVolume instance, Validator validator) {
        this.fluent = fluent;
        fluent.withDevicePath(instance.getDevicePath());
        fluent.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public AttachedVolumeBuilder(AttachedVolume instance, Validator validator) {
        this.fluent = this;
        this.withDevicePath(instance.getDevicePath());
        this.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public AttachedVolume build() {
        AttachedVolume buildable = new AttachedVolume(this.fluent.getDevicePath(), this.fluent.getName());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AttachedVolumeBuilder that = (AttachedVolumeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

