/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.AuthProviderConfig;
import io.ap4k.deps.kubernetes.api.model.AuthProviderConfigFluent;
import io.ap4k.deps.kubernetes.api.model.AuthProviderConfigFluentImpl;

public class AuthProviderConfigBuilder
extends AuthProviderConfigFluentImpl<AuthProviderConfigBuilder>
implements VisitableBuilder<AuthProviderConfig, AuthProviderConfigBuilder> {
    AuthProviderConfigFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AuthProviderConfigBuilder() {
        this(true);
    }

    public AuthProviderConfigBuilder(Boolean validationEnabled) {
        this(new AuthProviderConfig(), validationEnabled);
    }

    public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AuthProviderConfig(), validationEnabled);
    }

    public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent, AuthProviderConfig instance) {
        this(fluent, instance, true);
    }

    public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent, AuthProviderConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConfig(instance.getConfig());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public AuthProviderConfigBuilder(AuthProviderConfig instance) {
        this(instance, (Boolean)true);
    }

    public AuthProviderConfigBuilder(AuthProviderConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConfig(instance.getConfig());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public AuthProviderConfigBuilder(Validator validator) {
        this(new AuthProviderConfig(), (Boolean)true);
    }

    public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent, AuthProviderConfig instance, Validator validator) {
        this.fluent = fluent;
        fluent.withConfig(instance.getConfig());
        fluent.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public AuthProviderConfigBuilder(AuthProviderConfig instance, Validator validator) {
        this.fluent = this;
        this.withConfig(instance.getConfig());
        this.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public AuthProviderConfig build() {
        AuthProviderConfig buildable = new AuthProviderConfig(this.fluent.getConfig(), this.fluent.getName());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthProviderConfigBuilder that = (AuthProviderConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

