/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.EventSource;
import io.ap4k.deps.kubernetes.api.model.EventSourceFluent;
import io.ap4k.deps.kubernetes.api.model.EventSourceFluentImpl;

public class EventSourceBuilder
extends EventSourceFluentImpl<EventSourceBuilder>
implements VisitableBuilder<EventSource, EventSourceBuilder> {
    EventSourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public EventSourceBuilder() {
        this(true);
    }

    public EventSourceBuilder(Boolean validationEnabled) {
        this(new EventSource(), validationEnabled);
    }

    public EventSourceBuilder(EventSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EventSourceBuilder(EventSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EventSource(), validationEnabled);
    }

    public EventSourceBuilder(EventSourceFluent<?> fluent, EventSource instance) {
        this(fluent, instance, true);
    }

    public EventSourceBuilder(EventSourceFluent<?> fluent, EventSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withComponent(instance.getComponent());
        fluent.withHost(instance.getHost());
        this.validationEnabled = validationEnabled;
    }

    public EventSourceBuilder(EventSource instance) {
        this(instance, (Boolean)true);
    }

    public EventSourceBuilder(EventSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withComponent(instance.getComponent());
        this.withHost(instance.getHost());
        this.validationEnabled = validationEnabled;
    }

    public EventSourceBuilder(Validator validator) {
        this(new EventSource(), (Boolean)true);
    }

    public EventSourceBuilder(EventSourceFluent<?> fluent, EventSource instance, Validator validator) {
        this.fluent = fluent;
        fluent.withComponent(instance.getComponent());
        fluent.withHost(instance.getHost());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public EventSourceBuilder(EventSource instance, Validator validator) {
        this.fluent = this;
        this.withComponent(instance.getComponent());
        this.withHost(instance.getHost());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public EventSource build() {
        EventSource buildable = new EventSource(this.fluent.getComponent(), this.fluent.getHost());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventSourceBuilder that = (EventSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

