/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.ExecAction;
import io.ap4k.deps.kubernetes.api.model.ExecActionFluent;
import io.ap4k.deps.kubernetes.api.model.ExecActionFluentImpl;

public class ExecActionBuilder
extends ExecActionFluentImpl<ExecActionBuilder>
implements VisitableBuilder<ExecAction, ExecActionBuilder> {
    ExecActionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ExecActionBuilder() {
        this(true);
    }

    public ExecActionBuilder(Boolean validationEnabled) {
        this(new ExecAction(), validationEnabled);
    }

    public ExecActionBuilder(ExecActionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ExecActionBuilder(ExecActionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ExecAction(), validationEnabled);
    }

    public ExecActionBuilder(ExecActionFluent<?> fluent, ExecAction instance) {
        this(fluent, instance, true);
    }

    public ExecActionBuilder(ExecActionFluent<?> fluent, ExecAction instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCommand(instance.getCommand());
        this.validationEnabled = validationEnabled;
    }

    public ExecActionBuilder(ExecAction instance) {
        this(instance, (Boolean)true);
    }

    public ExecActionBuilder(ExecAction instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCommand(instance.getCommand());
        this.validationEnabled = validationEnabled;
    }

    public ExecActionBuilder(Validator validator) {
        this(new ExecAction(), (Boolean)true);
    }

    public ExecActionBuilder(ExecActionFluent<?> fluent, ExecAction instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCommand(instance.getCommand());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ExecActionBuilder(ExecAction instance, Validator validator) {
        this.fluent = this;
        this.withCommand(instance.getCommand());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ExecAction build() {
        ExecAction buildable = new ExecAction(this.fluent.getCommand());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecActionBuilder that = (ExecActionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

