/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.model.CrossVersionObjectReference;
import io.ap4k.deps.kubernetes.api.model.CrossVersionObjectReferenceBuilder;
import io.ap4k.deps.kubernetes.api.model.CrossVersionObjectReferenceFluentImpl;
import io.ap4k.deps.kubernetes.api.model.HorizontalPodAutoscalerSpec;
import io.ap4k.deps.kubernetes.api.model.HorizontalPodAutoscalerSpecFluent;

public class HorizontalPodAutoscalerSpecFluentImpl<A extends HorizontalPodAutoscalerSpecFluent<A>>
extends BaseFluent<A>
implements HorizontalPodAutoscalerSpecFluent<A> {
    private Integer maxReplicas;
    private Integer minReplicas;
    private CrossVersionObjectReferenceBuilder scaleTargetRef;
    private Integer targetCPUUtilizationPercentage;

    public HorizontalPodAutoscalerSpecFluentImpl() {
    }

    public HorizontalPodAutoscalerSpecFluentImpl(HorizontalPodAutoscalerSpec instance) {
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleTargetRef(instance.getScaleTargetRef());
        this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());
    }

    @Override
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    @Override
    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    @Override
    public A withNewMaxReplicas(String arg1) {
        return this.withMaxReplicas(new Integer(arg1));
    }

    @Override
    public A withNewMaxReplicas(int arg1) {
        return this.withMaxReplicas(new Integer(arg1));
    }

    @Override
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    @Override
    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    @Override
    public A withNewMinReplicas(String arg1) {
        return this.withMinReplicas(new Integer(arg1));
    }

    @Override
    public A withNewMinReplicas(int arg1) {
        return this.withMinReplicas(new Integer(arg1));
    }

    @Override
    @Deprecated
    public CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public CrossVersionObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public A withScaleTargetRef(CrossVersionObjectReference scaleTargetRef) {
        this._visitables.remove(this.scaleTargetRef);
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new CrossVersionObjectReferenceBuilder(scaleTargetRef);
            this._visitables.add(this.scaleTargetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    @Override
    public A withNewScaleTargetRef(String apiVersion, String kind, String name) {
        return this.withScaleTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return new ScaleTargetRefNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef());
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : new CrossVersionObjectReferenceBuilder().build());
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : item);
    }

    @Override
    public Integer getTargetCPUUtilizationPercentage() {
        return this.targetCPUUtilizationPercentage;
    }

    @Override
    public A withTargetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage) {
        this.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
        return (A)this;
    }

    @Override
    public Boolean hasTargetCPUUtilizationPercentage() {
        return this.targetCPUUtilizationPercentage != null;
    }

    @Override
    public A withNewTargetCPUUtilizationPercentage(String arg1) {
        return this.withTargetCPUUtilizationPercentage(new Integer(arg1));
    }

    @Override
    public A withNewTargetCPUUtilizationPercentage(int arg1) {
        return this.withTargetCPUUtilizationPercentage(new Integer(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerSpecFluentImpl that = (HorizontalPodAutoscalerSpecFluentImpl)o;
        if (this.maxReplicas != null ? !this.maxReplicas.equals(that.maxReplicas) : that.maxReplicas != null) {
            return false;
        }
        if (this.minReplicas != null ? !this.minReplicas.equals(that.minReplicas) : that.minReplicas != null) {
            return false;
        }
        if (this.scaleTargetRef != null ? !this.scaleTargetRef.equals(that.scaleTargetRef) : that.scaleTargetRef != null) {
            return false;
        }
        return !(this.targetCPUUtilizationPercentage != null ? !this.targetCPUUtilizationPercentage.equals(that.targetCPUUtilizationPercentage) : that.targetCPUUtilizationPercentage != null);
    }

    public class ScaleTargetRefNestedImpl<N>
    extends CrossVersionObjectReferenceFluentImpl<HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>>
    implements HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>,
    Nested<N> {
        private final CrossVersionObjectReferenceBuilder builder;

        ScaleTargetRefNestedImpl(CrossVersionObjectReference item) {
            this.builder = new CrossVersionObjectReferenceBuilder(this, item);
        }

        ScaleTargetRefNestedImpl() {
            this.builder = new CrossVersionObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluentImpl.this.withScaleTargetRef(this.builder.build());
        }

        @Override
        public N endScaleTargetRef() {
            return this.and();
        }
    }
}

