/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.model.HostAlias;
import io.ap4k.deps.kubernetes.api.model.HostAliasFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HostAliasFluentImpl<A extends HostAliasFluent<A>>
extends BaseFluent<A>
implements HostAliasFluent<A> {
    private List<String> hostnames;
    private String ip;

    public HostAliasFluentImpl() {
    }

    public HostAliasFluentImpl(HostAlias instance) {
        this.withHostnames(instance.getHostnames());
        this.withIp(instance.getIp());
    }

    @Override
    public A addToHostnames(int index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHostnames(int index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHostnames(String ... items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostnames(Collection<String> items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostnames(String ... items) {
        for (String item : items) {
            if (this.hostnames == null) continue;
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostnames(Collection<String> items) {
        for (String item : items) {
            if (this.hostnames == null) continue;
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHostnames() {
        return this.hostnames;
    }

    @Override
    public String getHostname(int index) {
        return this.hostnames.get(index);
    }

    @Override
    public String getFirstHostname() {
        return this.hostnames.get(0);
    }

    @Override
    public String getLastHostname() {
        return this.hostnames.get(this.hostnames.size() - 1);
    }

    @Override
    public String getMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withHostnames(List<String> hostnames) {
        if (this.hostnames != null) {
            this._visitables.removeAll(this.hostnames);
        }
        if (hostnames != null) {
            this.hostnames = new ArrayList<String>();
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        } else {
            this.hostnames = new ArrayList<String>();
        }
        return (A)this;
    }

    @Override
    public A withHostnames(String ... hostnames) {
        if (this.hostnames != null) {
            this.hostnames.clear();
        }
        if (hostnames != null) {
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostnames() {
        return this.hostnames != null && !this.hostnames.isEmpty();
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    @Override
    public Boolean hasIp() {
        return this.ip != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostAliasFluentImpl that = (HostAliasFluentImpl)o;
        if (this.hostnames != null ? !this.hostnames.equals(that.hostnames) : that.hostnames != null) {
            return false;
        }
        return !(this.ip != null ? !this.ip.equals(that.ip) : that.ip != null);
    }
}

