/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.model.NodeConfigSource;
import io.ap4k.deps.kubernetes.api.model.NodeConfigSourceFluent;
import io.ap4k.deps.kubernetes.api.model.ObjectReference;
import io.ap4k.deps.kubernetes.api.model.ObjectReferenceBuilder;
import io.ap4k.deps.kubernetes.api.model.ObjectReferenceFluentImpl;

public class NodeConfigSourceFluentImpl<A extends NodeConfigSourceFluent<A>>
extends BaseFluent<A>
implements NodeConfigSourceFluent<A> {
    private String apiVersion;
    private ObjectReferenceBuilder configMapRef;
    private String kind;

    public NodeConfigSourceFluentImpl() {
    }

    public NodeConfigSourceFluentImpl(NodeConfigSource instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withConfigMapRef(instance.getConfigMapRef());
        this.withKind(instance.getKind());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public ObjectReference getConfigMapRef() {
        return this.configMapRef != null ? this.configMapRef.build() : null;
    }

    @Override
    public ObjectReference buildConfigMapRef() {
        return this.configMapRef != null ? this.configMapRef.build() : null;
    }

    @Override
    public A withConfigMapRef(ObjectReference configMapRef) {
        this._visitables.remove(this.configMapRef);
        if (configMapRef != null) {
            this.configMapRef = new ObjectReferenceBuilder(configMapRef);
            this._visitables.add(this.configMapRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfigMapRef() {
        return this.configMapRef != null;
    }

    @Override
    public NodeConfigSourceFluent.ConfigMapRefNested<A> withNewConfigMapRef() {
        return new ConfigMapRefNestedImpl();
    }

    @Override
    public NodeConfigSourceFluent.ConfigMapRefNested<A> withNewConfigMapRefLike(ObjectReference item) {
        return new ConfigMapRefNestedImpl(item);
    }

    @Override
    public NodeConfigSourceFluent.ConfigMapRefNested<A> editConfigMapRef() {
        return this.withNewConfigMapRefLike(this.getConfigMapRef());
    }

    @Override
    public NodeConfigSourceFluent.ConfigMapRefNested<A> editOrNewConfigMapRef() {
        return this.withNewConfigMapRefLike(this.getConfigMapRef() != null ? this.getConfigMapRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public NodeConfigSourceFluent.ConfigMapRefNested<A> editOrNewConfigMapRefLike(ObjectReference item) {
        return this.withNewConfigMapRefLike(this.getConfigMapRef() != null ? this.getConfigMapRef() : item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeConfigSourceFluentImpl that = (NodeConfigSourceFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.configMapRef != null ? !this.configMapRef.equals(that.configMapRef) : that.configMapRef != null) {
            return false;
        }
        return !(this.kind != null ? !this.kind.equals(that.kind) : that.kind != null);
    }

    public class ConfigMapRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<NodeConfigSourceFluent.ConfigMapRefNested<N>>
    implements NodeConfigSourceFluent.ConfigMapRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        ConfigMapRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ConfigMapRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeConfigSourceFluentImpl.this.withConfigMapRef(this.builder.build());
        }

        @Override
        public N endConfigMapRef() {
            return this.and();
        }
    }
}

