/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.ServiceStatus;
import io.ap4k.deps.kubernetes.api.model.ServiceStatusFluent;
import io.ap4k.deps.kubernetes.api.model.ServiceStatusFluentImpl;

public class ServiceStatusBuilder
extends ServiceStatusFluentImpl<ServiceStatusBuilder>
implements VisitableBuilder<ServiceStatus, ServiceStatusBuilder> {
    ServiceStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServiceStatusBuilder() {
        this(true);
    }

    public ServiceStatusBuilder(Boolean validationEnabled) {
        this(new ServiceStatus(), validationEnabled);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceStatus(), validationEnabled);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, ServiceStatus instance) {
        this(fluent, instance, true);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, ServiceStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLoadBalancer(instance.getLoadBalancer());
        this.validationEnabled = validationEnabled;
    }

    public ServiceStatusBuilder(ServiceStatus instance) {
        this(instance, (Boolean)true);
    }

    public ServiceStatusBuilder(ServiceStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLoadBalancer(instance.getLoadBalancer());
        this.validationEnabled = validationEnabled;
    }

    public ServiceStatusBuilder(Validator validator) {
        this(new ServiceStatus(), (Boolean)true);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, ServiceStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withLoadBalancer(instance.getLoadBalancer());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ServiceStatusBuilder(ServiceStatus instance, Validator validator) {
        this.fluent = this;
        this.withLoadBalancer(instance.getLoadBalancer());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ServiceStatus build() {
        ServiceStatus buildable = new ServiceStatus(this.fluent.getLoadBalancer());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceStatusBuilder that = (ServiceStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

