/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model.apps;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.apps.Deployment;
import io.ap4k.deps.kubernetes.api.model.apps.DeploymentFluent;
import io.ap4k.deps.kubernetes.api.model.apps.DeploymentFluentImpl;

public class DeploymentBuilder
extends DeploymentFluentImpl<DeploymentBuilder>
implements VisitableBuilder<Deployment, DeploymentBuilder> {
    DeploymentFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public DeploymentBuilder() {
        this(true);
    }

    public DeploymentBuilder(Boolean validationEnabled) {
        this(new Deployment(), validationEnabled);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Deployment(), validationEnabled);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent, Deployment instance) {
        this(fluent, instance, true);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent, Deployment instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentBuilder(Deployment instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentBuilder(Deployment instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentBuilder(Validator validator) {
        this(new Deployment(), (Boolean)true);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent, Deployment instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public DeploymentBuilder(Deployment instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Deployment build() {
        Deployment buildable = new Deployment(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentBuilder that = (DeploymentBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

