/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model.apps;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.apps.DeploymentSpec;
import io.ap4k.deps.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.ap4k.deps.kubernetes.api.model.apps.DeploymentSpecFluentImpl;

public class DeploymentSpecBuilder
extends DeploymentSpecFluentImpl<DeploymentSpecBuilder>
implements VisitableBuilder<DeploymentSpec, DeploymentSpecBuilder> {
    DeploymentSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public DeploymentSpecBuilder() {
        this(true);
    }

    public DeploymentSpecBuilder(Boolean validationEnabled) {
        this(new DeploymentSpec(), validationEnabled);
    }

    public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentSpec(), validationEnabled);
    }

    public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent, DeploymentSpec instance) {
        this(fluent, instance, true);
    }

    public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent, DeploymentSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMinReadySeconds(instance.getMinReadySeconds());
        fluent.withPaused(instance.getPaused());
        fluent.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
        fluent.withReplicas(instance.getReplicas());
        fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        fluent.withSelector(instance.getSelector());
        fluent.withStrategy(instance.getStrategy());
        fluent.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentSpecBuilder(DeploymentSpec instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentSpecBuilder(DeploymentSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.getPaused());
        this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentSpecBuilder(Validator validator) {
        this(new DeploymentSpec(), (Boolean)true);
    }

    public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent, DeploymentSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withMinReadySeconds(instance.getMinReadySeconds());
        fluent.withPaused(instance.getPaused());
        fluent.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
        fluent.withReplicas(instance.getReplicas());
        fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        fluent.withSelector(instance.getSelector());
        fluent.withStrategy(instance.getStrategy());
        fluent.withTemplate(instance.getTemplate());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public DeploymentSpecBuilder(DeploymentSpec instance, Validator validator) {
        this.fluent = this;
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.getPaused());
        this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public DeploymentSpec build() {
        DeploymentSpec buildable = new DeploymentSpec(this.fluent.getMinReadySeconds(), this.fluent.isPaused(), this.fluent.getProgressDeadlineSeconds(), this.fluent.getReplicas(), this.fluent.getRevisionHistoryLimit(), this.fluent.getSelector(), this.fluent.getStrategy(), this.fluent.getTemplate());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentSpecBuilder that = (DeploymentSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

