/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.kubernetes.api.model.rbac;

import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.model.rbac.KubernetesRoleBinding;
import io.ap4k.deps.kubernetes.api.model.rbac.KubernetesRoleBindingFluent;
import io.ap4k.deps.kubernetes.api.model.rbac.KubernetesRoleBindingFluentImpl;

public class KubernetesRoleBindingBuilder
extends KubernetesRoleBindingFluentImpl<KubernetesRoleBindingBuilder>
implements VisitableBuilder<KubernetesRoleBinding, KubernetesRoleBindingBuilder> {
    KubernetesRoleBindingFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public KubernetesRoleBindingBuilder() {
        this(true);
    }

    public KubernetesRoleBindingBuilder(Boolean validationEnabled) {
        this(new KubernetesRoleBinding(), validationEnabled);
    }

    public KubernetesRoleBindingBuilder(KubernetesRoleBindingFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KubernetesRoleBindingBuilder(KubernetesRoleBindingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubernetesRoleBinding(), validationEnabled);
    }

    public KubernetesRoleBindingBuilder(KubernetesRoleBindingFluent<?> fluent, KubernetesRoleBinding instance) {
        this(fluent, instance, true);
    }

    public KubernetesRoleBindingBuilder(KubernetesRoleBindingFluent<?> fluent, KubernetesRoleBinding instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRoleRef(instance.getRoleRef());
        fluent.withSubjects(instance.getSubjects());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesRoleBindingBuilder(KubernetesRoleBinding instance) {
        this(instance, (Boolean)true);
    }

    public KubernetesRoleBindingBuilder(KubernetesRoleBinding instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesRoleBindingBuilder(Validator validator) {
        this(new KubernetesRoleBinding(), (Boolean)true);
    }

    public KubernetesRoleBindingBuilder(KubernetesRoleBindingFluent<?> fluent, KubernetesRoleBinding instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRoleRef(instance.getRoleRef());
        fluent.withSubjects(instance.getSubjects());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public KubernetesRoleBindingBuilder(KubernetesRoleBinding instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public KubernetesRoleBinding build() {
        KubernetesRoleBinding buildable = new KubernetesRoleBinding(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRoleRef(), this.fluent.getSubjects());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesRoleBindingBuilder that = (KubernetesRoleBindingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

